/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jul.reformatting;

import co.elastic.apm.agent.loginstr.AbstractLogIntegrationInstrumentation;
import java.util.Collection;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class JulLogReformattingInstrumentation
extends AbstractLogIntegrationInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        Collection<String> ret = super.getInstrumentationGroupNames();
        ret.add("jul-ecs");
        return ret;
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.isBootstrapClassLoader();
    }

    public static class StopAppenderInstrumentation
    extends JulLogReformattingInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("java.util.logging.ConsoleHandler").or(ElementMatchers.named("java.util.logging.FileHandler"));
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("close").and(ElementMatchers.takesArguments(0));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.jul.reformatting.JulHandlerCloseAdvice";
        }
    }

    public static class ConsoleReformattingInstrumentation
    extends JulLogReformattingInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("java.util.logging.ConsoleHandler");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("publish").and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.util.logging.LogRecord")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.jul.reformatting.JulConsoleHandlerPublishAdvice";
        }
    }

    public static class FileReformattingInstrumentation
    extends JulLogReformattingInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("java.util.logging.FileHandler");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("publish").and(ElementMatchers.takesArgument(0, ElementMatchers.named("java.util.logging.LogRecord")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.jul.reformatting.JulFileHandlerPublishAdvice";
        }
    }
}

