/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jul.reformatting;

import co.elastic.apm.agent.loginstr.reformatting.AbstractEcsReformattingHelper;
import co.elastic.apm.agent.loginstr.reformatting.Utils;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.LoggerUtils;
import co.elastic.logging.AdditionalField;
import co.elastic.logging.jul.EcsFormatter;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Formatter;
import java.util.logging.StreamHandler;
import javax.annotation.Nullable;

class JulEcsReformattingHelper
extends AbstractEcsReformattingHelper<StreamHandler, Formatter> {
    private static final Logger logger = LoggerFactory.getLogger(JulEcsReformattingHelper.class);
    private static final Logger oneTimeLogFileLimitWarningLogger = LoggerUtils.logOnce(logger);
    private static final ThreadLocal<String> currentPattern = new ThreadLocal();
    private static final ThreadLocal<Path> currentExampleLogFile = new ThreadLocal();

    JulEcsReformattingHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean onAppendEnter(FileHandler fileHandler, String pattern, File exampleLogFile) {
        try {
            currentPattern.set(pattern);
            currentExampleLogFile.set(exampleLogFile.toPath());
            boolean bl = super.onAppendEnter(fileHandler);
            return bl;
        }
        finally {
            currentPattern.remove();
            currentExampleLogFile.remove();
        }
    }

    @Override
    @Nullable
    protected Formatter getFormatterFrom(StreamHandler handler) {
        return handler.getFormatter();
    }

    @Override
    protected void setFormatter(StreamHandler handler, Formatter formatter) {
        handler.setFormatter(formatter);
    }

    @Override
    protected String getAppenderName(StreamHandler handler) {
        if (handler instanceof FileHandler) {
            return "FILE";
        }
        if (handler instanceof ConsoleHandler) {
            return "CONSOLE";
        }
        return handler.getClass().getSimpleName();
    }

    @Override
    protected Formatter createEcsFormatter(String eventDataset, @Nullable String serviceName, @Nullable String serviceVersion, @Nullable String serviceNodeName, @Nullable Map<String, String> additionalFields, Formatter originalFormatter) {
        EcsFormatter ecsFormatter = new EcsFormatter();
        ecsFormatter.setServiceName(serviceName);
        ecsFormatter.setServiceVersion(serviceVersion);
        ecsFormatter.setServiceNodeName(serviceNodeName);
        ecsFormatter.setEventDataset(eventDataset);
        if (additionalFields != null && !additionalFields.isEmpty()) {
            ArrayList<AdditionalField> additionalFieldList = new ArrayList<AdditionalField>();
            for (Map.Entry<String, String> keyValuePair : additionalFields.entrySet()) {
                additionalFieldList.add(new AdditionalField(keyValuePair.getKey(), keyValuePair.getValue()));
            }
            ecsFormatter.setAdditionalFields(additionalFieldList);
        }
        ecsFormatter.setIncludeOrigin(false);
        ecsFormatter.setStackTraceAsArray(false);
        return ecsFormatter;
    }

    @Override
    @Nullable
    protected StreamHandler createAndStartEcsAppender(StreamHandler originalHandler, String ecsAppenderName, Formatter ecsFormatter) {
        FileHandler shadeHandler = null;
        if (originalHandler instanceof FileHandler) {
            try {
                String pattern = JulEcsReformattingHelper.computeEcsFileHandlerPattern(currentPattern.get(), currentExampleLogFile.get(), this.getConfiguredReformattingDir(), true);
                int maxLogFileSize = (int)this.getMaxLogFileSize();
                if ((long)maxLogFileSize != this.getMaxLogFileSize()) {
                    maxLogFileSize = (int)this.getDefaultMaxLogFileSize();
                    oneTimeLogFileLimitWarningLogger.warn("Configured log max size ({} bytes) is too big for JUL settings, which use int to configure the file size limit. Consider reducing the log max size configuration to a value below Integer#MAX_VALUE. Defaulting to {} bytes.", (Object)this.getMaxLogFileSize(), (Object)maxLogFileSize);
                }
                shadeHandler = new FileHandler(pattern, maxLogFileSize, 2, true);
                shadeHandler.setFormatter(ecsFormatter);
            }
            catch (Exception e) {
                logger.error("Failed to create Log shading FileAppender. Auto ECS reformatting will not work.", e);
            }
        }
        return shadeHandler;
    }

    static String computeEcsFileHandlerPattern(String pattern, Path originalFilePath, @Nullable String configuredReformattingDir, boolean createDirs) throws IOException {
        Path logReformattingDir;
        int lastPathSeparatorIndex;
        if (!(pattern = Utils.replaceFileExtensionToEcsJson(pattern)).contains("%g")) {
            pattern = pattern + ".%g";
        }
        if ((lastPathSeparatorIndex = pattern.lastIndexOf(47)) > 0 && pattern.length() > lastPathSeparatorIndex) {
            pattern = pattern.substring(lastPathSeparatorIndex + 1);
        }
        if ((logReformattingDir = Utils.computeLogReformattingDir(originalFilePath, configuredReformattingDir)) != null) {
            if (createDirs && !Files.exists(logReformattingDir, new LinkOption[0])) {
                Files.createDirectories(logReformattingDir, new FileAttribute[0]);
            }
            pattern = logReformattingDir.resolve(pattern).toString();
        }
        return pattern;
    }

    @Override
    protected void closeShadeAppender(StreamHandler shadeHandler) {
        shadeHandler.close();
    }
}

