/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jmx;

import co.elastic.apm.agent.jmx.MapsTokenScanner;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import org.stagemonitor.configuration.converter.AbstractValueConverter;

public class JmxMetric {
    private static final String OBJECT_NAME = "object_name";
    private static final String ATTRIBUTE = "attribute";
    private static final String METRIC_NAME = "metric_name";
    private final ObjectName objectName;
    private final List<Attribute> attributes;

    private JmxMetric(ObjectName objectName, List<Attribute> attributes) {
        this.objectName = objectName;
        this.attributes = attributes;
    }

    public static JmxMetric valueOf(String s) {
        return (JmxMetric)TokenValueConverter.INSTANCE.convert(s).get(0);
    }

    @Nonnull
    private static JmxMetric fromMap(Map<String, List<String>> map) {
        ObjectName objectName;
        if (!map.containsKey(OBJECT_NAME)) {
            throw new IllegalArgumentException("object_name is missing");
        }
        if (!map.containsKey(ATTRIBUTE)) {
            throw new IllegalArgumentException("attribute is missing");
        }
        HashSet<String> unknownKeys = new HashSet<String>(map.keySet());
        unknownKeys.removeAll(Arrays.asList(OBJECT_NAME, ATTRIBUTE));
        if (!unknownKeys.isEmpty()) {
            throw new IllegalArgumentException("Unknown keys: " + unknownKeys);
        }
        String objectNameString = map.get(OBJECT_NAME).get(0);
        try {
            objectName = new ObjectName(objectNameString);
        }
        catch (MalformedObjectNameException e) {
            throw new IllegalArgumentException("Invalid syntax for object_name[" + objectNameString + "] (" + e.getMessage() + ")", e);
        }
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        for (String attribute : map.get(ATTRIBUTE)) {
            attributes.add(Attribute.valueOf(attribute));
        }
        return new JmxMetric(objectName, attributes);
    }

    public ObjectName getObjectName() {
        return this.objectName;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public String toString() {
        return TokenValueConverter.INSTANCE.toString(Collections.singletonList(this));
    }

    Map<String, List<String>> asMap() {
        LinkedHashMap<String, List<String>> map = new LinkedHashMap<String, List<String>>();
        map.put(OBJECT_NAME, Collections.singletonList(this.objectName.toString()));
        ArrayList<String> attributeStrings = new ArrayList<String>();
        for (Attribute attribute : this.attributes) {
            attributeStrings.add(attribute.toString());
        }
        map.put(ATTRIBUTE, attributeStrings);
        return map;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JmxMetric jmxMetric = (JmxMetric)o;
        return this.objectName.equals(jmxMetric.objectName) && this.attributes.equals(jmxMetric.attributes);
    }

    public int hashCode() {
        return Objects.hash(this.objectName, this.attributes);
    }

    public static class Attribute {
        public static final String IGNORE = "ignore";
        private final String stringRepresentation;
        private final String jmxAttributeName;
        @Nullable
        private final String metricName;

        public static Attribute valueOf(String s) {
            try {
                ObjectName objectName = !s.contains(":") ? new ObjectName(s, IGNORE, "this") : new ObjectName(s);
                HashSet<String> unknownProperties = new HashSet<String>(objectName.getKeyPropertyList().keySet());
                unknownProperties.removeAll(Arrays.asList(IGNORE, JmxMetric.METRIC_NAME));
                if (!unknownProperties.isEmpty()) {
                    throw new IllegalArgumentException("Unknown properties: " + unknownProperties);
                }
                return new Attribute(s, objectName.getDomain(), objectName.getKeyProperty(JmxMetric.METRIC_NAME));
            }
            catch (MalformedObjectNameException e) {
                throw new IllegalArgumentException("Invalid syntax for attribute[" + s + "] (" + e.getMessage() + ")", e);
            }
        }

        private Attribute(String stringRepresentation, String jmxAttributeName, @Nullable String metricName) {
            this.stringRepresentation = stringRepresentation;
            this.jmxAttributeName = jmxAttributeName;
            this.metricName = metricName;
        }

        public String getJmxAttributeName() {
            return this.jmxAttributeName;
        }

        public String getMetricName() {
            return this.metricName != null ? this.metricName : this.jmxAttributeName;
        }

        public String toString() {
            return this.stringRepresentation;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Attribute attribute = (Attribute)o;
            return this.jmxAttributeName.equals(attribute.jmxAttributeName) && Objects.equals(this.metricName, attribute.metricName);
        }

        public int hashCode() {
            return Objects.hash(this.jmxAttributeName, this.metricName);
        }
    }

    public static class TokenValueConverter
    extends AbstractValueConverter<List<JmxMetric>> {
        public static final TokenValueConverter INSTANCE = new TokenValueConverter();

        @Override
        public List<JmxMetric> convert(String s) throws IllegalArgumentException {
            ArrayList<JmxMetric> result = new ArrayList<JmxMetric>();
            List<Map<String, List<String>>> maps = new MapsTokenScanner(s).scanMultiValueMaps();
            for (Map<String, List<String>> map : maps) {
                result.add(JmxMetric.fromMap(map));
            }
            return Collections.unmodifiableList(result);
        }

        @Override
        public String toString(List<JmxMetric> value) {
            ArrayList<Map<String, List<String>>> maps = new ArrayList<Map<String, List<String>>>();
            for (JmxMetric jmxMetric : value) {
                maps.add(jmxMetric.asMap());
            }
            return MapsTokenScanner.toTokenString(maps);
        }
    }
}

