/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jms;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.configuration.MessagingConfiguration;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.jms.BaseJmsInstrumentation;
import co.elastic.apm.agent.jms.JmsInstrumentationHelper;
import co.elastic.apm.agent.jms.JmsMessagePropertyAccessor;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import javax.annotation.Nullable;
import javax.jms.Destination;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class JmsMessageConsumerInstrumentation
extends BaseJmsInstrumentation {
    public static final Logger logger = LoggerFactory.getLogger(JmsMessageConsumerInstrumentation.class);

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Message").or(ElementMatchers.nameContains("Consumer")).or(ElementMatchers.nameContains("Receiver")).or(ElementMatchers.nameContains("Subscriber"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("javax.jms.MessageConsumer")));
    }

    public static class SetMessageListenerInstrumentation
    extends JmsMessageConsumerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("setMessageListener").and(ElementMatchers.takesArgument(0, ElementMatchers.named("javax.jms.MessageListener")));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.jms.JmsMessageConsumerInstrumentation$SetMessageListenerInstrumentation$ListenerWrappingAdvice";
        }

        public static class ListenerWrappingAdvice
        extends BaseJmsInstrumentation.BaseAdvice {
            @Nullable
            @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=0)})
            @Advice.OnMethodEnter(inline=false)
            public static MessageListener beforeSetListener(@Advice.Argument(value=0) @Nullable MessageListener original) {
                return helper.wrapLambda(original);
            }
        }
    }

    public static class ReceiveInstrumentation
    extends JmsMessageConsumerInstrumentation {
        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("receive").and(ElementMatchers.takesArguments(0).or(ElementMatchers.takesArguments(1))).and(ElementMatchers.isPublic()).or(ElementMatchers.named("receiveNoWait").and(ElementMatchers.takesArguments(0).and(ElementMatchers.isPublic())));
        }

        @Override
        public String getAdviceClassName() {
            return "co.elastic.apm.agent.jms.JmsMessageConsumerInstrumentation$ReceiveInstrumentation$MessageConsumerAdvice";
        }

        public static class MessageConsumerAdvice
        extends BaseJmsInstrumentation.BaseAdvice {
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            @Nullable
            public static Object beforeReceive(@Advice.Origin Class<?> clazz, @Advice.Origin(value="#m") String methodName) {
                AbstractSpan createdSpan = null;
                boolean createPollingTransaction = false;
                boolean createPollingSpan = false;
                AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
                if (parent == null) {
                    createPollingTransaction = true;
                } else if (parent instanceof Transaction) {
                    Transaction transaction = (Transaction)parent;
                    if (JmsInstrumentationHelper.MESSAGE_POLLING.equals(transaction.getType())) {
                        return null;
                    }
                    if (JmsInstrumentationHelper.MESSAGE_HANDLING.equals(transaction.getType())) {
                        transaction.withType(JmsInstrumentationHelper.MESSAGING_TYPE);
                        ((Transaction)transaction.deactivate()).end();
                        createPollingTransaction = true;
                    } else {
                        createPollingSpan = true;
                    }
                } else if (parent instanceof Span) {
                    Span parentSpan = (Span)parent;
                    if (JmsInstrumentationHelper.MESSAGING_TYPE.equals(parentSpan.getType()) && "receive".equals(parentSpan.getAction())) {
                        return null;
                    }
                    createPollingSpan = true;
                }
                createPollingTransaction &= messagingConfiguration.getMessagePollingTransactionStrategy() != MessagingConfiguration.JmsStrategy.HANDLING;
                createPollingTransaction |= "receiveNoWait".equals(methodName);
                if (createPollingSpan) {
                    createdSpan = ((Span)parent.createSpan().withType(JmsInstrumentationHelper.MESSAGING_TYPE)).withSubtype("jms").withAction("receive");
                } else if (createPollingTransaction && (createdSpan = TracerAwareInstrumentation.tracer.startRootTransaction(clazz.getClassLoader())) != null) {
                    createdSpan.withType(JmsInstrumentationHelper.MESSAGE_POLLING);
                }
                if (createdSpan != null) {
                    createdSpan.withName(JmsInstrumentationHelper.RECEIVE_NAME_PREFIX);
                    createdSpan.activate();
                }
                return createdSpan;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Advice.OnMethodExit(onThrowable=Throwable.class, suppress=Throwable.class, inline=false)
            public static void afterReceive(@Advice.Origin Class<?> clazz, @Advice.Origin(value="#m") String methodName, @Advice.Enter @Nullable Object abstractSpanObj, @Advice.Return @Nullable Message message, @Advice.Thrown @Nullable Throwable throwable) {
                Transaction messageHandlingTransaction;
                AbstractSpan abstractSpan = null;
                if (abstractSpanObj instanceof AbstractSpan) {
                    abstractSpan = (AbstractSpan)abstractSpanObj;
                }
                Destination destination = null;
                String destinationName = null;
                boolean discard = false;
                boolean addDetails = true;
                if (message != null) {
                    try {
                        destination = message.getJMSDestination();
                        destinationName = helper.extractDestinationName(message, destination);
                        discard = helper.ignoreDestination(destinationName);
                    }
                    catch (JMSException e) {
                        logger.error("Failed to retrieve meta info from Message", e);
                    }
                    if (abstractSpan instanceof Transaction) {
                        Transaction transaction = (Transaction)abstractSpan;
                        if (discard) {
                            transaction.ignoreTransaction();
                        } else {
                            helper.makeChildOf(transaction, message);
                            transaction.withType(JmsInstrumentationHelper.MESSAGING_TYPE);
                            helper.addMessageDetails(message, abstractSpan);
                        }
                    } else if (abstractSpan != null) {
                        abstractSpan.addSpanLink(TraceContext.getFromTraceContextTextHeaders(), JmsMessagePropertyAccessor.instance(), message);
                    }
                } else if (abstractSpan instanceof Transaction) {
                    ((Transaction)abstractSpan).ignoreTransaction();
                    addDetails = false;
                }
                if (abstractSpan != null) {
                    try {
                        if (discard) {
                            abstractSpan.requestDiscarding();
                        } else if (addDetails) {
                            if (message != null && destinationName != null) {
                                abstractSpan.appendToName(" from ");
                                helper.addDestinationDetails(destination, destinationName, abstractSpan);
                                helper.setMessageAge(message, abstractSpan);
                            }
                            abstractSpan.captureException(throwable);
                        }
                    }
                    finally {
                        ((AbstractSpan)abstractSpan.deactivate()).end();
                    }
                }
                if (!discard && TracerAwareInstrumentation.tracer.currentTransaction() == null && message != null && messagingConfiguration.getMessagePollingTransactionStrategy() != MessagingConfiguration.JmsStrategy.POLLING && !"receiveNoWait".equals(methodName) && (messageHandlingTransaction = helper.startJmsTransaction(message, clazz)) != null) {
                    ((Transaction)messageHandlingTransaction.withType(JmsInstrumentationHelper.MESSAGE_HANDLING)).withName(JmsInstrumentationHelper.RECEIVE_NAME_PREFIX);
                    if (destinationName != null) {
                        messageHandlingTransaction.appendToName(" from ");
                        helper.addDestinationDetails(destination, destinationName, messageHandlingTransaction);
                        helper.addMessageDetails(message, messageHandlingTransaction);
                        helper.setMessageAge(message, messageHandlingTransaction);
                    }
                    messageHandlingTransaction.activate();
                }
            }
        }
    }
}

