/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jdbc;

import co.elastic.apm.agent.jdbc.JdbcInstrumentation;
import co.elastic.apm.agent.jdbc.helper.JdbcHelper;
import java.sql.PreparedStatement;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class ConnectionInstrumentation
extends JdbcInstrumentation {
    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Connection");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.hasSuperType(ElementMatchers.named("java.sql.Connection")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.nameStartsWith("prepare").and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("java.sql.PreparedStatement")))).and(ElementMatchers.takesArgument(0, String.class)).and(ElementMatchers.isPublic());
    }

    public static class AdviceClass {
        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void storeSql(@Advice.Return @Nullable PreparedStatement statement, @Advice.Argument(value=0) String sql) {
            if (statement != null) {
                JdbcHelper.get().mapStatementToSql(statement, sql);
            }
        }
    }
}

