/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jbosslogging.correlation;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.jbosslogging.correlation.JBossLogManagerCorrelationHelper;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.jboss.logmanager.ExtLogRecord;

public class JBossLogManagerCorrelationInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("jboss-logging-correlation");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.jboss.logmanager.Logger"));
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("org.jboss.logmanager.Logger");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("logRaw").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.jboss.logmanager.ExtLogRecord")));
    }

    public static class AdviceClass {
        private static final JBossLogManagerCorrelationHelper helper = new JBossLogManagerCorrelationHelper();

        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static boolean addToMdc(@Advice.Argument(value=0) ExtLogRecord record) {
            return helper.beforeLoggingEvent(record);
        }

        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void removeFromMdc(@Advice.Enter boolean addedToMdc) {
            helper.afterLoggingEvent(addedToMdc);
        }
    }
}

