/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.jaxws;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.bci.bytebuddy.SimpleMethodSignatureOffsetMappingFactory;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JaxWsTransactionNameInstrumentation
extends TracerAwareInstrumentation {
    private static final String FRAMEWORK_NAME = "JAX-WS";
    private final Collection<String> applicationPackages;

    public JaxWsTransactionNameInstrumentation(ElasticApmTracer tracer) {
        this.applicationPackages = tracer.getConfig(StacktraceConfiguration.class).getApplicationPackages();
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any());
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.not(ElementMatchers.isInterface()).and(ElementMatchers.not(CustomElementMatchers.isProxy())).and(ElementMatchers.isAnnotatedWith(ElementMatchers.namedOneOf("javax.jws.WebService", "jakarta.jws.WebService")));
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("javax.jws.WebService").or(CustomElementMatchers.classLoaderCanLoadClass("jakarta.jws.WebService")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return CustomElementMatchers.overridesOrImplementsMethodThat(ElementMatchers.isAnnotatedWith(ElementMatchers.namedOneOf("javax.jws.WebMethod", "jakarta.jws.WebMethod"))).onSuperClassesThat(CustomElementMatchers.isInAnyPackage(this.applicationPackages, ElementMatchers.any()));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singletonList("jax-ws");
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void setTransactionName(@SimpleMethodSignatureOffsetMappingFactory.SimpleMethodSignature String signature) {
            Transaction transaction = TracerAwareInstrumentation.tracer.currentTransaction();
            if (transaction != null) {
                transaction.withName(signature, 100);
                transaction.setFrameworkName(JaxWsTransactionNameInstrumentation.FRAMEWORK_NAME);
            }
        }
    }
}

