/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.javalin;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import io.javalin.http.Context;
import io.javalin.http.Handler;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class JavalinHandlerLambdaInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.javalin.Javalin");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("addHandler").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.javalin.http.HandlerType"))).and(ElementMatchers.takesArgument(1, String.class)).and(ElementMatchers.takesArgument(2, ElementMatchers.named("io.javalin.http.Handler"))).and(ElementMatchers.takesArguments(4));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("javalin");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return CustomElementMatchers.classLoaderCanLoadClass("io.javalin.http.Handler");
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.javalin.JavalinHandlerLambdaInstrumentation$HandlerWrappingAdvice";
    }

    static class WrappingHandler
    implements Handler {
        private final Handler wrappingHandler;

        public WrappingHandler(Handler wrappingHandler) {
            this.wrappingHandler = wrappingHandler;
        }

        public void handle(@Nonnull Context ctx) throws Exception {
            this.wrappingHandler.handle(ctx);
        }
    }

    public static class HandlerWrappingAdvice {
        @Nullable
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=2)})
        @Advice.OnMethodEnter(inline=false)
        public static Handler beforeAddHandler(@Advice.Argument(value=2) @Nullable Handler original) {
            if (original != null && original.getClass().getName().contains("/")) {
                return new WrappingHandler(original);
            }
            return original;
        }
    }
}

