/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.SpanConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.TransactionContext;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.DroppedSpanStats;
import co.elastic.apm.agent.impl.transaction.Faas;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.SpanCount;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.metrics.Labels;
import co.elastic.apm.agent.metrics.MetricRegistry;
import co.elastic.apm.agent.metrics.Timer;
import co.elastic.apm.agent.util.KeyListConcurrentHashMap;
import java.util.List;
import javax.annotation.Nullable;
import org.HdrHistogram.WriterReaderPhaser;

public class Transaction
extends AbstractSpan<Transaction> {
    private static final ThreadLocal<Labels.Mutable> labelsThreadLocal = new ThreadLocal<Labels.Mutable>(){

        @Override
        protected Labels.Mutable initialValue() {
            return Labels.Mutable.of();
        }
    };
    public static final String TYPE_REQUEST = "request";
    private final TransactionContext context = new TransactionContext();
    private final SpanCount spanCount = new SpanCount();
    private final DroppedSpanStats droppedSpanStats = new DroppedSpanStats();
    private final KeyListConcurrentHashMap<String, KeyListConcurrentHashMap<String, Timer>> timerBySpanTypeAndSubtype = new KeyListConcurrentHashMap();
    private final WriterReaderPhaser phaser = new WriterReaderPhaser();
    @Nullable
    private String result;
    private boolean noop;
    private int maxSpans;
    private boolean spanCompressionEnabled;
    private long spanCompressionExactMatchMaxDurationUs;
    private long spanCompressionSameKindMaxDurationUs;
    @Nullable
    private String frameworkName;
    private boolean frameworkNameSetByUser;
    @Nullable
    private String frameworkVersion;
    private final Faas faas = new Faas();

    @Override
    public Transaction getTransaction() {
        return this;
    }

    public Transaction(ElasticApmTracer tracer) {
        super(tracer);
    }

    public <T> Transaction start(TraceContext.ChildContextCreator<T> childContextCreator, @Nullable T parent, long epochMicros, Sampler sampler) {
        boolean startedAsChild = parent != null && childContextCreator.asChildOf(this.traceContext, parent);
        this.onTransactionStart(startedAsChild, epochMicros, sampler);
        return this;
    }

    public <T, A> Transaction start(TraceContext.ChildContextCreatorTwoArg<T, A> childContextCreator, @Nullable T parent, A arg, long epochMicros, Sampler sampler) {
        boolean startedAsChild = childContextCreator.asChildOf(this.traceContext, parent, arg);
        this.onTransactionStart(startedAsChild, epochMicros, sampler);
        return this;
    }

    private void onTransactionStart(boolean startedAsChild, long epochMicros, Sampler sampler) {
        this.maxSpans = this.tracer.getConfig(CoreConfiguration.class).getTransactionMaxSpans();
        this.spanCompressionEnabled = this.tracer.getConfig(SpanConfiguration.class).isSpanCompressionEnabled();
        this.spanCompressionExactMatchMaxDurationUs = this.tracer.getConfig(SpanConfiguration.class).getSpanCompressionExactMatchMaxDuration().getMicros();
        this.spanCompressionSameKindMaxDurationUs = this.tracer.getConfig(SpanConfiguration.class).getSpanCompressionSameKindMaxDuration().getMicros();
        if (!startedAsChild) {
            this.traceContext.asRootSpan(sampler);
        }
        if (epochMicros >= 0L) {
            this.setStartTimestamp(epochMicros);
        } else {
            this.setStartTimestampNow();
        }
        this.onAfterStart();
    }

    public Transaction startNoop() {
        this.name.append("noop");
        this.noop = true;
        this.onAfterStart();
        return this;
    }

    @Override
    public TransactionContext getContext() {
        return this.context;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransactionContext getContextEnsureVisibility() {
        Transaction transaction = this;
        synchronized (transaction) {
            return this.context;
        }
    }

    @Nullable
    public String getResult() {
        return this.result;
    }

    public Transaction withResultIfUnset(@Nullable String result) {
        if (this.result == null) {
            this.result = result;
        }
        return this;
    }

    public Transaction withResult(@Nullable String result) {
        this.result = result;
        return this;
    }

    public void setUser(String id, String email, String username, String domain) {
        if (!this.isSampled()) {
            return;
        }
        this.getContext().getUser().withDomain(domain).withId(id).withEmail(email).withUsername(username);
    }

    @Override
    public void beforeEnd(long epochMicros) {
        if (!this.isSampled()) {
            this.context.resetState();
        }
        if (this.outcomeNotSet()) {
            Response response = this.getContext().getResponse();
            int httpStatus = response.getStatusCode();
            Outcome outcome = httpStatus > 0 ? ResultUtil.getOutcomeByHttpServerStatus(httpStatus) : (this.hasCapturedExceptions() ? Outcome.FAILURE : Outcome.SUCCESS);
            this.withOutcome(outcome);
        }
        this.context.onTransactionEnd();
        this.incrementTimer("app", null, this.getSelfDuration());
    }

    @Override
    protected void afterEnd() {
        this.trackMetrics();
        this.tracer.endTransaction(this);
    }

    public SpanCount getSpanCount() {
        return this.spanCount;
    }

    public void captureDroppedSpan(Span span) {
        if (span.isSampled()) {
            this.spanCount.getDropped().incrementAndGet();
        }
        this.droppedSpanStats.captureDroppedSpan(span);
    }

    public DroppedSpanStats getDroppedSpanStats() {
        return this.droppedSpanStats;
    }

    boolean isSpanLimitReached() {
        return this.getSpanCount().isSpanLimitReached(this.maxSpans);
    }

    public KeyListConcurrentHashMap<String, KeyListConcurrentHashMap<String, Timer>> getTimerBySpanTypeAndSubtype() {
        return this.timerBySpanTypeAndSubtype;
    }

    @Override
    public void resetState() {
        super.resetState();
        this.context.resetState();
        this.result = null;
        this.spanCount.resetState();
        this.droppedSpanStats.resetState();
        this.noop = false;
        this.maxSpans = 0;
        this.spanCompressionEnabled = false;
        this.spanCompressionExactMatchMaxDurationUs = 0L;
        this.spanCompressionSameKindMaxDurationUs = 0L;
        this.frameworkName = null;
        this.frameworkVersion = null;
        this.faas.resetState();
    }

    public boolean isNoop() {
        return this.noop;
    }

    public void ignoreTransaction() {
        this.noop = true;
    }

    public void addCustomContext(String key, String value) {
        if (this.isSampled()) {
            this.getContext().addCustom(key, value);
        }
    }

    public void addCustomContext(String key, Number value) {
        if (this.isSampled()) {
            this.getContext().addCustom(key, value);
        }
    }

    public void addCustomContext(String key, Boolean value) {
        if (this.isSampled()) {
            this.getContext().addCustom(key, value);
        }
    }

    public String toString() {
        return String.format("'%s' %s (%s)", this.name, this.traceContext, Integer.toHexString(System.identityHashCode(this)));
    }

    @Override
    public void incrementReferences() {
        super.incrementReferences();
    }

    @Override
    protected void recycle() {
        this.tracer.recycle(this);
    }

    public void setFrameworkName(@Nullable String frameworkName) {
        if (this.frameworkNameSetByUser) {
            return;
        }
        this.frameworkName = frameworkName;
    }

    public void setUserFrameworkName(@Nullable String frameworkName) {
        this.frameworkName = frameworkName != null && frameworkName.isEmpty() ? null : frameworkName;
        this.frameworkNameSetByUser = true;
    }

    @Nullable
    public String getFrameworkName() {
        return this.frameworkName;
    }

    public void setFrameworkVersion(@Nullable String frameworkVersion) {
        this.frameworkVersion = frameworkVersion;
    }

    @Nullable
    public String getFrameworkVersion() {
        return this.frameworkVersion;
    }

    public Faas getFaas() {
        return this.faas;
    }

    public boolean isSpanCompressionEnabled() {
        return this.spanCompressionEnabled;
    }

    public long getSpanCompressionExactMatchMaxDurationUs() {
        return this.spanCompressionExactMatchMaxDurationUs;
    }

    public long getSpanCompressionSameKindMaxDurationUs() {
        return this.spanCompressionSameKindMaxDurationUs;
    }

    @Override
    protected Transaction thiz() {
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void incrementTimer(@Nullable String type, @Nullable String subtype, long duration) {
        long criticalValueAtEnter = this.phaser.writerCriticalSectionEnter();
        try {
            Timer racyTimer;
            Timer timer;
            KeyListConcurrentHashMap racyMap;
            KeyListConcurrentHashMap<String, Timer> timersBySubtype;
            if (!this.collectBreakdownMetrics || type == null || this.finished) {
                return;
            }
            if (subtype == null) {
                subtype = "";
            }
            if ((timersBySubtype = (KeyListConcurrentHashMap<String, Timer>)this.timerBySpanTypeAndSubtype.get(type)) == null && (racyMap = this.timerBySpanTypeAndSubtype.putIfAbsent(type, timersBySubtype = new KeyListConcurrentHashMap<String, Timer>())) != null) {
                timersBySubtype = racyMap;
            }
            if ((timer = (Timer)timersBySubtype.get(subtype)) == null && (racyTimer = timersBySubtype.putIfAbsent(subtype, timer = new Timer())) != null) {
                timer = racyTimer;
            }
            timer.update(duration);
            if (this.finished) {
                timer.resetState();
            }
        }
        finally {
            this.phaser.writerCriticalSectionExit(criticalValueAtEnter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trackMetrics() {
        try {
            this.phaser.readerLock();
            this.phaser.flipPhase();
            String type = this.getType();
            if (type == null) {
                return;
            }
            Labels.Mutable labels = labelsThreadLocal.get();
            labels.resetState();
            labels.serviceName(this.getTraceContext().getServiceName()).serviceVersion(this.getTraceContext().getServiceVersion()).transactionName(this.name).transactionType(type);
            MetricRegistry metricRegistry = this.tracer.getMetricRegistry();
            long criticalValueAtEnter = metricRegistry.writerCriticalSectionEnter();
            try {
                if (this.collectBreakdownMetrics) {
                    List<String> types = this.timerBySpanTypeAndSubtype.keyList();
                    for (int i = 0; i < types.size(); ++i) {
                        String spanType = types.get(i);
                        KeyListConcurrentHashMap timerBySubtype = (KeyListConcurrentHashMap)this.timerBySpanTypeAndSubtype.get(spanType);
                        List subtypes = timerBySubtype.keyList();
                        for (int j = 0; j < subtypes.size(); ++j) {
                            String subtype = (String)subtypes.get(j);
                            Timer timer = (Timer)timerBySubtype.get(subtype);
                            if (timer.getCount() <= 0L) continue;
                            if (subtype.equals("")) {
                                subtype = null;
                            }
                            labels.spanType(spanType).spanSubType(subtype);
                            metricRegistry.updateTimer("span.self_time", labels, timer.getTotalTimeUs(), timer.getCount());
                            timer.resetState();
                        }
                    }
                }
            }
            finally {
                metricRegistry.writerCriticalSectionExit(criticalValueAtEnter);
            }
        }
        finally {
            this.phaser.readerUnlock();
        }
    }
}

