/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Tracer;
import co.elastic.apm.agent.impl.sampling.Sampler;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.BinaryHeaderGetter;
import co.elastic.apm.agent.impl.transaction.BinaryHeaderSetter;
import co.elastic.apm.agent.impl.transaction.EpochTickClock;
import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.HeaderRemover;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderGetter;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.TraceState;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.ByteUtils;
import co.elastic.apm.agent.util.HexUtils;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import javax.annotation.Nullable;

public class TraceContext
implements Recyclable {
    public static final String ELASTIC_TRACE_PARENT_TEXTUAL_HEADER_NAME = "elastic-apm-traceparent";
    public static final String W3C_TRACE_PARENT_TEXTUAL_HEADER_NAME = "traceparent";
    public static final String TRACESTATE_HEADER_NAME = "tracestate";
    public static final int SERIALIZED_LENGTH = 42;
    private static final int TEXT_HEADER_EXPECTED_LENGTH = 55;
    private static final int TEXT_HEADER_TRACE_ID_OFFSET = 3;
    private static final int TEXT_HEADER_PARENT_ID_OFFSET = 36;
    private static final int TEXT_HEADER_FLAGS_OFFSET = 53;
    public static final String TRACE_PARENT_BINARY_HEADER_NAME = "elasticapmtraceparent";
    public static final int BINARY_FORMAT_EXPECTED_LENGTH = 29;
    private static final byte BINARY_FORMAT_CURRENT_VERSION = 0;
    private static final int BINARY_FORMAT_TRACE_ID_OFFSET = 1;
    private static final byte BINARY_FORMAT_TRACE_ID_FIELD_ID = 0;
    private static final int BINARY_FORMAT_PARENT_ID_OFFSET = 18;
    private static final byte BINARY_FORMAT_PARENT_ID_FIELD_ID = 1;
    private static final int BINARY_FORMAT_FLAGS_OFFSET = 27;
    private static final byte BINARY_FORMAT_FLAGS_FIELD_ID = 2;
    private static final Logger logger = LoggerFactory.getLogger(TraceContext.class);
    private static final Double SAMPLE_RATE_ZERO = 0.0;
    private static final ChildContextCreator<TraceContext> FROM_PARENT_CONTEXT = new ChildContextCreator<TraceContext>(){

        @Override
        public boolean asChildOf(TraceContext child, TraceContext parent) {
            child.asChildOf(parent);
            return true;
        }
    };
    private static final ChildContextCreator<AbstractSpan<?>> FROM_PARENT = new ChildContextCreator<AbstractSpan<?>>(){

        @Override
        public boolean asChildOf(TraceContext child, AbstractSpan<?> parent) {
            child.asChildOf(parent.getTraceContext());
            return true;
        }
    };
    private static final HeaderGetter.HeaderConsumer<String, TraceContext> TRACESTATE_HEADER_CONSUMER = new HeaderGetter.HeaderConsumer<String, TraceContext>(){

        @Override
        public void accept(@Nullable String tracestateHeaderValue, TraceContext state) {
            if (tracestateHeaderValue != null) {
                state.traceState.addTextHeader(tracestateHeaderValue);
            }
        }
    };
    private static final ChildContextCreatorTwoArg FROM_TRACE_CONTEXT_TEXT_HEADERS = new ChildContextCreatorTwoArg<Object, TextHeaderGetter<Object>>(){

        @Override
        public boolean asChildOf(TraceContext child, @Nullable Object carrier, TextHeaderGetter<Object> traceContextHeaderGetter) {
            if (carrier == null) {
                return false;
            }
            boolean isValid = false;
            String traceparent = (String)traceContextHeaderGetter.getFirstHeader(TraceContext.W3C_TRACE_PARENT_TEXTUAL_HEADER_NAME, carrier);
            if (traceparent != null) {
                isValid = child.asChildOf(traceparent);
            }
            if (!isValid && (traceparent = (String)traceContextHeaderGetter.getFirstHeader(TraceContext.ELASTIC_TRACE_PARENT_TEXTUAL_HEADER_NAME, carrier)) != null) {
                isValid = child.asChildOf(traceparent);
            }
            if (isValid) {
                traceContextHeaderGetter.forEach(TraceContext.TRACESTATE_HEADER_NAME, carrier, child, TRACESTATE_HEADER_CONSUMER);
            }
            return isValid;
        }
    };
    private static final ChildContextCreatorTwoArg FROM_TRACE_CONTEXT_BINARY_HEADERS = new ChildContextCreatorTwoArg<Object, BinaryHeaderGetter<Object>>(){

        @Override
        public boolean asChildOf(TraceContext child, @Nullable Object carrier, BinaryHeaderGetter<Object> traceContextHeaderGetter) {
            if (carrier == null) {
                return false;
            }
            byte[] traceparent = (byte[])traceContextHeaderGetter.getFirstHeader(TraceContext.TRACE_PARENT_BINARY_HEADER_NAME, carrier);
            if (traceparent != null) {
                return child.asChildOf(traceparent);
            }
            return false;
        }
    };
    private static final ChildContextCreator<Tracer> FROM_ACTIVE = new ChildContextCreator<Tracer>(){

        @Override
        public boolean asChildOf(TraceContext child, Tracer tracer) {
            AbstractSpan<?> active = tracer.getActive();
            if (active != null) {
                return TraceContext.fromParent().asChildOf(child, active);
            }
            return false;
        }
    };
    private static final ChildContextCreator<Object> AS_ROOT = new ChildContextCreator<Object>(){

        @Override
        public boolean asChildOf(TraceContext child, Object ignore) {
            return false;
        }
    };
    private static final byte FLAG_RECORDED = 1;
    private final Id traceId = Id.new128BitId();
    private final ElasticApmTracer tracer;
    private final Id id;
    private final Id parentId = Id.new64BitId();
    private final Id transactionId = Id.new64BitId();
    private final StringBuilder outgoingTextHeader = new StringBuilder(55);
    private byte flags;
    private boolean discardable = true;
    private final TraceState traceState;
    final CoreConfiguration coreConfiguration;
    private final EpochTickClock clock = new EpochTickClock();
    @Nullable
    private String serviceName;
    @Nullable
    private String serviceVersion;

    public static <C> boolean containsTraceContextTextHeaders(C carrier, TextHeaderGetter<C> headerGetter) {
        return headerGetter.getFirstHeader(W3C_TRACE_PARENT_TEXTUAL_HEADER_NAME, carrier) != null;
    }

    public static <C> void removeTraceContextHeaders(C carrier, HeaderRemover<C> headerRemover) {
        headerRemover.remove(W3C_TRACE_PARENT_TEXTUAL_HEADER_NAME, carrier);
        headerRemover.remove(ELASTIC_TRACE_PARENT_TEXTUAL_HEADER_NAME, carrier);
        headerRemover.remove(TRACESTATE_HEADER_NAME, carrier);
        headerRemover.remove(TRACE_PARENT_BINARY_HEADER_NAME, carrier);
    }

    public static <S, D> void copyTraceContextTextHeaders(S source, TextHeaderGetter<S> headerGetter, D destination, TextHeaderSetter<D> headerSetter) {
        String tracestate;
        String elasticApmTraceParent;
        String w3cApmTraceParent = (String)headerGetter.getFirstHeader(W3C_TRACE_PARENT_TEXTUAL_HEADER_NAME, source);
        if (w3cApmTraceParent != null) {
            headerSetter.setHeader(W3C_TRACE_PARENT_TEXTUAL_HEADER_NAME, w3cApmTraceParent, destination);
        }
        if ((elasticApmTraceParent = (String)headerGetter.getFirstHeader(ELASTIC_TRACE_PARENT_TEXTUAL_HEADER_NAME, source)) != null) {
            headerSetter.setHeader(ELASTIC_TRACE_PARENT_TEXTUAL_HEADER_NAME, elasticApmTraceParent, destination);
        }
        if ((tracestate = (String)headerGetter.getFirstHeader(TRACESTATE_HEADER_NAME, source)) != null) {
            headerSetter.setHeader(TRACESTATE_HEADER_NAME, tracestate, destination);
        }
    }

    private TraceContext(ElasticApmTracer tracer, Id id) {
        this.coreConfiguration = tracer.getConfig(CoreConfiguration.class);
        this.traceState = new TraceState();
        this.traceState.setSizeLimit(this.coreConfiguration.getTracestateSizeLimit());
        this.tracer = tracer;
        this.id = id;
    }

    public static TraceContext with64BitId(ElasticApmTracer tracer) {
        return new TraceContext(tracer, Id.new64BitId());
    }

    public static TraceContext with128BitId(ElasticApmTracer tracer) {
        return new TraceContext(tracer, Id.new128BitId());
    }

    public static <C> ChildContextCreatorTwoArg<C, HeaderGetter<String, C>> getFromTraceContextTextHeaders() {
        return FROM_TRACE_CONTEXT_TEXT_HEADERS;
    }

    public static <C> ChildContextCreatorTwoArg<C, HeaderGetter<byte[], C>> getFromTraceContextBinaryHeaders() {
        return FROM_TRACE_CONTEXT_BINARY_HEADERS;
    }

    public static ChildContextCreator<Tracer> fromActive() {
        return FROM_ACTIVE;
    }

    public static ChildContextCreator<TraceContext> fromParentContext() {
        return FROM_PARENT_CONTEXT;
    }

    public static ChildContextCreator<AbstractSpan<?>> fromParent() {
        return FROM_PARENT;
    }

    public static ChildContextCreator<?> asRoot() {
        return AS_ROOT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean asChildOf(String traceParentHeader) {
        traceParentHeader = traceParentHeader.trim();
        try {
            if (traceParentHeader.length() < 55) {
                logger.warn("The traceparent header has to be at least 55 chars long, but was '{}'", (Object)traceParentHeader);
                boolean bl = false;
                return bl;
            }
            if (this.noDashAtPosition(traceParentHeader, 2) || this.noDashAtPosition(traceParentHeader, 35) || this.noDashAtPosition(traceParentHeader, 52)) {
                logger.warn("The traceparent header has an invalid format: '{}'", (Object)traceParentHeader);
                boolean bl = false;
                return bl;
            }
            if (traceParentHeader.length() > 55 && this.noDashAtPosition(traceParentHeader, 55)) {
                logger.warn("The traceparent header has an invalid format: '{}'", (Object)traceParentHeader);
                boolean bl = false;
                return bl;
            }
            if (traceParentHeader.startsWith("ff")) {
                logger.warn("Version ff is not supported");
                boolean bl = false;
                return bl;
            }
            byte version = HexUtils.getNextByte(traceParentHeader, 0);
            if (version == 0 && traceParentHeader.length() > 55) {
                logger.warn("The traceparent header has to be exactly 55 chars long for version 00, but was '{}'", (Object)traceParentHeader);
                boolean bl = false;
                return bl;
            }
            this.traceId.fromHexString(traceParentHeader, 3);
            if (this.traceId.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.parentId.fromHexString(traceParentHeader, 36);
            if (this.parentId.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.id.setToRandomValue();
            this.transactionId.copyFrom(this.id);
            this.flags = HexUtils.getNextByte(traceParentHeader, 53);
            this.clock.init();
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.onMutation();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean asChildOf(byte[] traceParentHeader) {
        if (logger.isTraceEnabled()) {
            logger.trace("Binary header content UTF-8-decoded: {}", (Object)new String(traceParentHeader, StandardCharsets.UTF_8));
        }
        try {
            if (traceParentHeader.length < 29) {
                logger.warn("The traceparent header has to be at least 29 bytes long, but is not");
                boolean bl = false;
                return bl;
            }
            byte fieldId = traceParentHeader[1];
            if (fieldId != 0) {
                logger.warn("Wrong trace-id field identifier: {}", (Object)fieldId);
                boolean bl = false;
                return bl;
            }
            this.traceId.fromBytes(traceParentHeader, 2);
            if (this.traceId.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            fieldId = traceParentHeader[18];
            if (fieldId != 1) {
                logger.warn("Wrong parent-id field identifier: {}", (Object)fieldId);
                boolean bl = false;
                return bl;
            }
            this.parentId.fromBytes(traceParentHeader, 19);
            if (this.parentId.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            this.id.setToRandomValue();
            this.transactionId.copyFrom(this.id);
            fieldId = traceParentHeader[27];
            if (fieldId != 2) {
                logger.warn("Wrong flags field identifier: {}", (Object)fieldId);
                boolean bl = false;
                return bl;
            }
            this.flags = traceParentHeader[28];
            this.clock.init();
            boolean bl = true;
            return bl;
        }
        catch (IllegalArgumentException e) {
            logger.warn(e.getMessage());
            boolean bl = false;
            return bl;
        }
        finally {
            this.onMutation();
        }
    }

    private boolean noDashAtPosition(String traceParentHeader, int index) {
        return traceParentHeader.charAt(index) != '-';
    }

    public void asRootSpan(Sampler sampler) {
        this.traceId.setToRandomValue();
        this.id.setToRandomValue();
        this.transactionId.copyFrom(this.id);
        if (sampler.isSampled(this.traceId)) {
            this.flags = 1;
            this.traceState.set(sampler.getSampleRate(), sampler.getTraceStateHeader());
        }
        this.clock.init();
        this.onMutation();
    }

    public void asChildOf(TraceContext parent) {
        this.traceId.copyFrom(parent.traceId);
        this.parentId.copyFrom(parent.id);
        this.transactionId.copyFrom(parent.transactionId);
        this.flags = parent.flags;
        this.id.setToRandomValue();
        this.clock.init(parent.clock);
        this.serviceName = parent.serviceName;
        this.serviceVersion = parent.serviceVersion;
        this.traceState.copyFrom(parent.traceState);
        this.onMutation();
    }

    @Override
    public void resetState() {
        this.traceId.resetState();
        this.id.resetState();
        this.parentId.resetState();
        this.transactionId.resetState();
        this.outgoingTextHeader.setLength(0);
        this.flags = 0;
        this.discardable = true;
        this.clock.resetState();
        this.serviceName = null;
        this.serviceVersion = null;
        this.traceState.resetState();
        this.traceState.setSizeLimit(this.coreConfiguration.getTracestateSizeLimit());
    }

    public Id getTraceId() {
        return this.traceId;
    }

    public Id getId() {
        return this.id;
    }

    public Id getParentId() {
        return this.parentId;
    }

    public Id getTransactionId() {
        return this.transactionId;
    }

    public EpochTickClock getClock() {
        return this.clock;
    }

    public boolean isSampled() {
        return this.isRecorded();
    }

    public double getSampleRate() {
        if (this.isRecorded()) {
            return this.traceState.getSampleRate();
        }
        return SAMPLE_RATE_ZERO;
    }

    boolean isRecorded() {
        return (this.flags & 1) == 1;
    }

    void setRecorded(boolean recorded) {
        this.flags = recorded ? (byte)(this.flags | 1) : (byte)(this.flags & 0xFFFFFFFE);
    }

    void setNonDiscardable() {
        this.discardable = false;
    }

    boolean isDiscardable() {
        return this.discardable;
    }

    String getIncomingTraceParentHeader() {
        StringBuilder sb = new StringBuilder(55);
        this.fillTraceParentHeader(sb, this.parentId);
        return sb.toString();
    }

    <C> void propagateTraceContext(C carrier, TextHeaderSetter<C> headerSetter) {
        String outgoingTraceState;
        String outgoingTraceParent = this.getOutgoingTraceParentTextHeader().toString();
        headerSetter.setHeader(W3C_TRACE_PARENT_TEXTUAL_HEADER_NAME, outgoingTraceParent, carrier);
        if (this.coreConfiguration.isElasticTraceparentHeaderEnabled()) {
            headerSetter.setHeader(ELASTIC_TRACE_PARENT_TEXTUAL_HEADER_NAME, outgoingTraceParent, carrier);
        }
        if ((outgoingTraceState = this.traceState.toTextHeader()) != null) {
            headerSetter.setHeader(TRACESTATE_HEADER_NAME, outgoingTraceState, carrier);
        }
        logger.trace("Trace context headers added to {}", (Object)carrier);
    }

    <C> boolean propagateTraceContext(C carrier, BinaryHeaderSetter<C> headerSetter) {
        boolean headerBufferFilled;
        byte[] buffer = headerSetter.getFixedLengthByteArray(TRACE_PARENT_BINARY_HEADER_NAME, 29);
        if (buffer == null || buffer.length != 29) {
            logger.warn("Header setter {} failed to provide a byte buffer with the proper length. Allocating a buffer for each header.", (Object)headerSetter.getClass().getName());
            buffer = new byte[29];
        }
        if (headerBufferFilled = this.fillOutgoingTraceParentBinaryHeader(buffer)) {
            headerSetter.setHeader(TRACE_PARENT_BINARY_HEADER_NAME, buffer, carrier);
        }
        return headerBufferFilled;
    }

    StringBuilder getOutgoingTraceParentTextHeader() {
        if (this.outgoingTextHeader.length() == 0) {
            this.fillTraceParentHeader(this.outgoingTextHeader, this.isSampled() ? this.id : this.transactionId);
        }
        return this.outgoingTextHeader;
    }

    private void fillTraceParentHeader(StringBuilder sb, Id spanId) {
        sb.append("00-");
        this.traceId.writeAsHex(sb);
        sb.append('-');
        spanId.writeAsHex(sb);
        sb.append('-');
        HexUtils.writeByteAsHex(this.flags, sb);
    }

    private boolean fillOutgoingTraceParentBinaryHeader(byte[] buffer) {
        if (buffer.length < 29) {
            logger.warn("Given byte array does not have the minimal required length - {}", (Object)29);
            return false;
        }
        buffer[0] = 0;
        buffer[1] = 0;
        this.traceId.toBytes(buffer, 2);
        buffer[18] = 1;
        Id parentId = this.isSampled() ? this.id : this.transactionId;
        parentId.toBytes(buffer, 19);
        buffer[27] = 2;
        buffer[28] = this.flags;
        return true;
    }

    public boolean isChildOf(TraceContext other) {
        return other.getTraceId().equals(this.traceId) && other.getId().equals(this.parentId);
    }

    public boolean hasContent() {
        return !this.id.isEmpty();
    }

    public void copyFrom(TraceContext other) {
        this.traceId.copyFrom(other.traceId);
        this.id.copyFrom(other.id);
        this.parentId.copyFrom(other.parentId);
        this.transactionId.copyFrom(other.transactionId);
        this.flags = other.flags;
        this.discardable = other.discardable;
        this.clock.init(other.clock);
        this.serviceName = other.serviceName;
        this.serviceVersion = other.serviceVersion;
        this.traceState.copyFrom(other.traceState);
        this.onMutation();
    }

    public String toString() {
        return this.getOutgoingTraceParentTextHeader().toString();
    }

    private void onMutation() {
        this.outgoingTextHeader.setLength(0);
    }

    public boolean isRoot() {
        return this.parentId.isEmpty();
    }

    @Nullable
    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceInfo(@Nullable String serviceName, @Nullable String serviceVersion) {
        if (serviceName == null || serviceName.isEmpty()) {
            return;
        }
        this.serviceName = serviceName;
        this.serviceVersion = serviceVersion;
    }

    @Nullable
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public Span createSpan() {
        return this.tracer.startSpan(TraceContext.fromParentContext(), this);
    }

    public Span createSpan(long epochMicros) {
        return this.tracer.startSpan(TraceContext.fromParentContext(), this, epochMicros);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TraceContext that = (TraceContext)o;
        return this.id.equals(that.id) && this.traceId.equals(that.traceId);
    }

    public boolean idEquals(@Nullable TraceContext o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return this.id.equals(o.id);
    }

    public int hashCode() {
        return Objects.hash(this.traceId, this.id, this.parentId, this.flags);
    }

    public TraceState getTraceState() {
        return this.traceState;
    }

    public byte[] serialize() {
        byte[] result = new byte[42];
        this.serialize(result);
        return result;
    }

    public void serialize(byte[] buffer) {
        int offset = 0;
        offset = this.traceId.toBytes(buffer, offset);
        offset = this.id.toBytes(buffer, offset);
        offset = this.transactionId.toBytes(buffer, offset);
        buffer[offset++] = this.flags;
        buffer[offset++] = (byte)(this.discardable ? 1 : 0);
        ByteUtils.putLong(buffer, offset, this.clock.getOffset());
    }

    private void asChildOf(byte[] buffer, @Nullable String serviceName, @Nullable String serviceVersion) {
        int offset = 0;
        offset += this.traceId.fromBytes(buffer, offset);
        offset += this.parentId.fromBytes(buffer, offset);
        offset += this.transactionId.fromBytes(buffer, offset);
        this.id.setToRandomValue();
        this.flags = buffer[offset++];
        this.discardable = buffer[offset++] == 1;
        this.clock.init(ByteUtils.getLong(buffer, offset));
        this.serviceName = serviceName;
        this.serviceVersion = serviceVersion;
        this.onMutation();
    }

    public void deserialize(byte[] buffer, @Nullable String serviceName, @Nullable String serviceVersion) {
        int offset = 0;
        offset += this.traceId.fromBytes(buffer, offset);
        offset += this.id.fromBytes(buffer, offset);
        offset += this.transactionId.fromBytes(buffer, offset);
        this.flags = buffer[offset++];
        this.discardable = buffer[offset++] == 1;
        this.clock.init(ByteUtils.getLong(buffer, offset));
        this.serviceName = serviceName;
        this.serviceVersion = serviceVersion;
        this.onMutation();
    }

    public static void deserializeSpanId(Id id, byte[] buffer) {
        id.fromBytes(buffer, 16);
    }

    public static long getSpanId(byte[] serializedTraceContext) {
        return ByteUtils.getLong(serializedTraceContext, 16);
    }

    public boolean traceIdAndIdEquals(byte[] serialized) {
        return this.id.dataEquals(serialized, this.traceId.getLength()) && this.traceId.dataEquals(serialized, 0);
    }

    public byte getFlags() {
        return this.flags;
    }

    public TraceContext copy() {
        TraceContext copy;
        int idLength = this.id.getLength();
        if (idLength == 8) {
            copy = TraceContext.with64BitId(this.tracer);
        } else if (idLength == 16) {
            copy = TraceContext.with128BitId(this.tracer);
        } else {
            throw new IllegalStateException("Id has invalid length: " + idLength);
        }
        copy.copyFrom(this);
        return copy;
    }

    public static interface ChildContextCreatorTwoArg<T, A> {
        public boolean asChildOf(TraceContext var1, @Nullable T var2, A var3);
    }

    public static interface ChildContextCreator<T> {
        public boolean asChildOf(TraceContext var1, T var2);
    }
}

