/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.Db;
import co.elastic.apm.agent.impl.context.Message;
import co.elastic.apm.agent.impl.context.ServiceTarget;
import co.elastic.apm.agent.impl.context.SpanContext;
import co.elastic.apm.agent.impl.context.Url;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Composite;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.SpanCount;
import co.elastic.apm.agent.impl.transaction.StackFrame;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.CharSequenceUtils;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;

public class Span
extends AbstractSpan<Span>
implements Recyclable {
    private static final Logger logger = LoggerFactory.getLogger(Span.class);
    public static final long MAX_LOG_INTERVAL_MICRO_SECS = TimeUnit.MINUTES.toMicros(5L);
    private static long lastSpanMaxWarningTimestamp;
    @Nullable
    private String subtype;
    @Nullable
    private String action;
    private final SpanContext context = new SpanContext();
    private final Composite composite = new Composite();
    @Nullable
    private Throwable stacktrace;
    @Nullable
    private AbstractSpan<?> parent;
    @Nullable
    private Transaction transaction;
    @Nullable
    private List<StackFrame> stackFrames;

    @Override
    public void setNonDiscardable() {
        if (this.isDiscardable()) {
            this.getTraceContext().setNonDiscardable();
            if (this.parent != null) {
                this.parent.setNonDiscardable();
            }
        }
    }

    public Span(ElasticApmTracer tracer) {
        super(tracer);
    }

    public <T> Span start(TraceContext.ChildContextCreator<T> childContextCreator, T parentContext, long epochMicros) {
        childContextCreator.asChildOf(this.traceContext, parentContext);
        if (parentContext instanceof Transaction) {
            this.parent = this.transaction = (Transaction)parentContext;
        } else if (parentContext instanceof Span) {
            Span parentSpan;
            this.parent = parentSpan = (Span)parentContext;
            this.transaction = parentSpan.transaction;
        }
        return this.start(epochMicros);
    }

    private Span start(long epochMicros) {
        if (this.transaction != null) {
            SpanCount spanCount = this.transaction.getSpanCount();
            if (this.transaction.isSpanLimitReached()) {
                if (epochMicros - lastSpanMaxWarningTimestamp > MAX_LOG_INTERVAL_MICRO_SECS) {
                    lastSpanMaxWarningTimestamp = epochMicros;
                    logger.warn("Max spans ({}) for transaction {} has been reached. For this transaction and possibly others, further spans will be dropped. See config param 'transaction_max_spans'.", (Object)this.tracer.getConfig(CoreConfiguration.class).getTransactionMaxSpans(), (Object)this.transaction);
                }
                logger.debug("Span exceeds transaction_max_spans {}", (Object)this);
                this.traceContext.setRecorded(false);
                spanCount.getDropped().incrementAndGet();
            }
            spanCount.getTotal().incrementAndGet();
        }
        if (epochMicros >= 0L) {
            this.setStartTimestamp(epochMicros);
        } else {
            this.setStartTimestampNow();
        }
        if (logger.isDebugEnabled()) {
            logger.debug("startSpan {}", (Object)this);
            if (logger.isTraceEnabled()) {
                logger.trace("starting span at", new RuntimeException("this exception is just used to record where the span has been started from"));
            }
        }
        this.onAfterStart();
        return this;
    }

    @Override
    protected void onAfterStart() {
        super.onAfterStart();
        if (this.parent != null) {
            this.parent.incrementReferences();
            this.parent.onChildStart(this.getTimestamp());
        }
    }

    @Override
    public SpanContext getContext() {
        return this.context;
    }

    public boolean isComposite() {
        return this.composite.getCount() > 0;
    }

    public Composite getComposite() {
        return this.composite;
    }

    public Span withSubtype(@Nullable String subtype) {
        this.subtype = Span.normalizeEmpty(subtype);
        return this;
    }

    public Span withAction(@Nullable String action) {
        this.action = Span.normalizeEmpty(action);
        return this;
    }

    @Deprecated
    public void setType(@Nullable String type, @Nullable String subtype, @Nullable String action) {
        String temp;
        int indexOfFirstDot;
        if (type != null && (subtype == null || subtype.isEmpty()) && (action == null || action.isEmpty()) && (indexOfFirstDot = (temp = type).indexOf(".")) > 0) {
            type = temp.substring(0, indexOfFirstDot);
            int indexOfSecondDot = temp.indexOf(".", indexOfFirstDot + 1);
            if (indexOfSecondDot > 0) {
                subtype = temp.substring(indexOfFirstDot + 1, indexOfSecondDot);
                if (indexOfSecondDot + 1 < temp.length()) {
                    action = temp.substring(indexOfSecondDot + 1);
                }
            }
        }
        this.withType(type);
        this.withSubtype(subtype);
        this.withAction(action);
    }

    @Nullable
    public Throwable getStacktrace() {
        return this.stacktrace;
    }

    @Nullable
    public String getSubtype() {
        return this.subtype;
    }

    @Nullable
    public String getAction() {
        return this.action;
    }

    @Override
    public void beforeEnd(long epochMicros) {
        if (this.outcomeNotSet()) {
            Outcome outcome = this.context.getHttp().hasContent() ? ResultUtil.getOutcomeByHttpClientStatus(this.context.getHttp().getStatusCode()) : (this.hasCapturedExceptions() ? Outcome.FAILURE : Outcome.SUCCESS);
            this.withOutcome(outcome);
        }
        ServiceTarget serviceTarget = this.getContext().getServiceTarget();
        if (this.isExit() && !serviceTarget.hasContent() && !serviceTarget.isSetByUser()) {
            String targetServiceType;
            Db db = this.context.getDb();
            Message message = this.context.getMessage();
            Url httpUrl = this.context.getHttp().getInternalUrl();
            String string = targetServiceType = this.subtype != null ? this.subtype : this.type;
            if (db.hasContent()) {
                serviceTarget.withType(targetServiceType).withName(db.getInstance());
            } else if (message.hasContent()) {
                serviceTarget.withType(targetServiceType).withName(message.getQueueName());
            } else if (httpUrl.hasContent()) {
                serviceTarget.withType("http").withHostPortName(httpUrl.getHostname(), httpUrl.getPort()).withNameOnlyDestinationResource();
            } else {
                serviceTarget.withType(targetServiceType);
            }
        }
        if (this.transaction != null) {
            this.transaction.incrementTimer(this.type, this.subtype, this.getSelfDuration());
        }
        if (this.parent != null) {
            this.parent.onChildEnd(epochMicros);
        }
    }

    @Override
    protected void afterEnd() {
        if (this.transaction != null && this.transaction.isSpanCompressionEnabled() && this.parent != null) {
            Span buffered = this.parent.bufferedSpan.get();
            if (this.parent.isFinished() || !this.isCompressionEligible()) {
                if (buffered != null && this.parent.bufferedSpan.compareAndSet(buffered, null)) {
                    this.tracer.endSpan(buffered);
                }
                this.parent.decrementReferences();
                this.tracer.endSpan(this);
                return;
            }
            if (buffered == null) {
                if (!this.parent.bufferedSpan.compareAndSet(null, this)) {
                    this.tracer.endSpan(this);
                }
                this.parent.decrementReferences();
                return;
            }
            if (!buffered.tryToCompress(this)) {
                if (this.parent.bufferedSpan.compareAndSet(buffered, this)) {
                    this.tracer.endSpan(buffered);
                } else {
                    this.tracer.endSpan(this);
                }
                this.parent.decrementReferences();
            } else if (this.isSampled()) {
                Transaction transaction = this.getTransaction();
                if (transaction != null) {
                    transaction.getSpanCount().getDropped().incrementAndGet();
                }
                this.parent.decrementReferences();
                this.decrementReferences();
            }
        } else {
            if (this.parent != null) {
                this.parent.decrementReferences();
            }
            this.tracer.endSpan(this);
        }
    }

    private boolean isCompressionEligible() {
        return this.isExit() && this.isDiscardable() && (this.outcomeNotSet() || this.getOutcome() == Outcome.SUCCESS);
    }

    private boolean tryToCompress(Span sibling) {
        long currentEndTimestamp;
        long currentTimestamp;
        boolean canBeCompressed;
        boolean bl = canBeCompressed = this.isComposite() ? this.tryToCompressComposite(sibling) : this.tryToCompressRegular(sibling);
        if (!canBeCompressed) {
            return false;
        }
        while ((currentTimestamp = this.timestamp.get()) > sibling.timestamp.get() && !this.timestamp.compareAndSet(currentTimestamp, sibling.timestamp.get())) {
        }
        do {
            currentEndTimestamp = this.endTimestamp.get();
        } while (sibling.endTimestamp.get() > currentEndTimestamp && !this.endTimestamp.compareAndSet(currentEndTimestamp, sibling.endTimestamp.get()));
        this.composite.increaseCount();
        this.composite.increaseSum(sibling.getDuration());
        return true;
    }

    private boolean tryToCompressRegular(Span sibling) {
        if (!this.isSameKind(sibling)) {
            return false;
        }
        long currentDuration = this.getDuration();
        if (this.isComposite()) {
            return this.tryToCompressComposite(sibling);
        }
        if (CharSequenceUtils.equals(this.name, sibling.name)) {
            long maxExactMatchDuration = this.transaction.getSpanCompressionExactMatchMaxDurationUs();
            if (currentDuration <= maxExactMatchDuration && sibling.getDuration() <= maxExactMatchDuration) {
                if (!this.composite.init(currentDuration, "exact_match")) {
                    return this.tryToCompressComposite(sibling);
                }
                return true;
            }
            return false;
        }
        long maxSameKindDuration = this.transaction.getSpanCompressionSameKindMaxDurationUs();
        if (currentDuration <= maxSameKindDuration && sibling.getDuration() <= maxSameKindDuration) {
            if (!this.composite.init(currentDuration, "same_kind")) {
                return this.tryToCompressComposite(sibling);
            }
            this.setCompressedSpanName();
            return true;
        }
        return false;
    }

    private void setCompressedSpanName() {
        this.name.setLength(0);
        ServiceTarget serviceTarget = this.context.getServiceTarget();
        String serviceType = serviceTarget.getType();
        CharSequence serviceName = serviceTarget.getName();
        this.name.append("Calls to ");
        if (serviceType == null && serviceName == null) {
            this.name.append("unknown");
        } else {
            boolean hasType;
            boolean bl = hasType = serviceType != null;
            if (hasType) {
                this.name.append(serviceType);
            }
            if (serviceName != null) {
                if (hasType) {
                    this.name.append('/');
                }
                this.name.append(serviceName);
            }
        }
    }

    private boolean tryToCompressComposite(Span sibling) {
        String compressionStrategy = this.composite.getCompressionStrategy();
        if (compressionStrategy == null) {
            return false;
        }
        switch (compressionStrategy) {
            case "exact_match": {
                long maxExactMatchDuration = this.transaction.getSpanCompressionExactMatchMaxDurationUs();
                return this.isSameKind(sibling) && CharSequenceUtils.equals(this.name, sibling.name) && sibling.getDuration() <= maxExactMatchDuration;
            }
            case "same_kind": {
                long maxSameKindDuration = this.transaction.getSpanCompressionSameKindMaxDurationUs();
                return this.isSameKind(sibling) && sibling.getDuration() <= maxSameKindDuration;
            }
        }
        return false;
    }

    private boolean isSameKind(Span other) {
        ServiceTarget serviceTarget = this.context.getServiceTarget();
        ServiceTarget otherServiceTarget = other.context.getServiceTarget();
        return Objects.equals(this.type, other.type) && Objects.equals(this.subtype, other.subtype) && Objects.equals(serviceTarget.getType(), otherServiceTarget.getType()) && CharSequenceUtils.equals(serviceTarget.getName(), otherServiceTarget.getName());
    }

    @Override
    public void resetState() {
        super.resetState();
        this.context.resetState();
        this.composite.resetState();
        this.stacktrace = null;
        this.subtype = null;
        this.action = null;
        this.parent = null;
        this.transaction = null;
        this.stackFrames = null;
    }

    public String toString() {
        return String.format("'%s' %s (%s)", this.name, this.traceContext, Integer.toHexString(System.identityHashCode(this)));
    }

    public Span withStacktrace(Throwable stacktrace) {
        this.stacktrace = stacktrace;
        return this;
    }

    @Override
    public void incrementReferences() {
        if (this.transaction != null) {
            this.transaction.incrementReferences();
        }
        super.incrementReferences();
    }

    @Override
    public void decrementReferences() {
        if (this.transaction != null) {
            this.transaction.decrementReferences();
        }
        super.decrementReferences();
    }

    @Override
    protected void recycle() {
        this.tracer.recycle(this);
    }

    @Override
    protected Span thiz() {
        return this;
    }

    public void setStackTrace(List<StackFrame> stackTrace) {
        this.stackFrames = stackTrace;
    }

    @Nullable
    public List<StackFrame> getStackFrames() {
        return this.stackFrames;
    }

    @Override
    @Nullable
    public Transaction getTransaction() {
        return this.transaction;
    }

    @Nullable
    public AbstractSpan<?> getParent() {
        return this.parent;
    }
}

