/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;

public class Composite
implements Recyclable {
    private final AtomicInteger count = new AtomicInteger(0);
    private final AtomicLong sum = new AtomicLong(0L);
    private final AtomicReference<String> compressionStrategy = new AtomicReference<Object>(null);

    public boolean init(long sum, String compressionStrategy) {
        if (!this.count.compareAndSet(0, 1)) {
            return false;
        }
        this.sum.set(sum);
        this.compressionStrategy.set(compressionStrategy);
        return true;
    }

    public int getCount() {
        return this.count.get();
    }

    public void increaseCount() {
        this.count.incrementAndGet();
    }

    public long getSum() {
        return this.sum.get();
    }

    public double getSumMs() {
        return (double)this.sum.get() / 1000.0;
    }

    public void increaseSum(long delta) {
        this.sum.addAndGet(delta);
    }

    public String getCompressionStrategy() {
        return this.compressionStrategy.get();
    }

    @Override
    public void resetState() {
        this.count.set(0);
        this.sum.set(0L);
        this.compressionStrategy.set(null);
    }
}

