/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.transaction;

import co.elastic.apm.agent.collections.LongList;
import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.Scope;
import co.elastic.apm.agent.impl.context.AbstractContext;
import co.elastic.apm.agent.impl.transaction.BinaryHeaderSetter;
import co.elastic.apm.agent.impl.transaction.ElasticContext;
import co.elastic.apm.agent.impl.transaction.HeaderGetter;
import co.elastic.apm.agent.impl.transaction.Id;
import co.elastic.apm.agent.impl.transaction.OTelSpanKind;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TextHeaderSetter;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.UniqueSpanLinkArrayList;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.objectpool.Recyclable;
import co.elastic.apm.agent.report.ReporterConfiguration;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.LoggerUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;

public abstract class AbstractSpan<T extends AbstractSpan<T>>
implements Recyclable,
ElasticContext<T> {
    public static final int PRIO_USER_SUPPLIED = 1000;
    public static final int PRIO_HIGH_LEVEL_FRAMEWORK = 100;
    public static final int PRIO_METHOD_SIGNATURE = 100;
    public static final int PRIO_LOW_LEVEL_FRAMEWORK = 10;
    public static final int PRIO_DEFAULT = 0;
    private static final Logger logger = LoggerFactory.getLogger(AbstractSpan.class);
    private static final Logger oneTimeDuplicatedEndLogger = LoggerUtils.logOnce(logger);
    private static final Logger oneTimeMaxSpanLinksLogger = LoggerUtils.logOnce(logger);
    protected static final double MS_IN_MICROS = TimeUnit.MILLISECONDS.toMicros(1L);
    protected final TraceContext traceContext;
    protected final StringBuilder name = new StringBuilder();
    protected final boolean collectBreakdownMetrics;
    protected final ElasticApmTracer tracer;
    protected final AtomicLong timestamp = new AtomicLong();
    protected final AtomicLong endTimestamp = new AtomicLong();
    private ChildDurationTimer childDurations = new ChildDurationTimer();
    protected AtomicInteger references = new AtomicInteger();
    protected volatile boolean finished = true;
    private int namePriority = 0;
    private boolean discardRequested = false;
    private boolean isExit;
    @Nullable
    private LongList childIds;
    @Nullable
    private Outcome outcome;
    @Nullable
    private Outcome userOutcome = null;
    private boolean hasCapturedExceptions;
    @Nullable
    protected volatile String type;
    protected volatile boolean sync = true;
    protected final AtomicReference<Span> bufferedSpan = new AtomicReference();
    public static final int MAX_ALLOWED_SPAN_LINKS = 1000;
    private final List<TraceContext> spanLinks = new UniqueSpanLinkArrayList();
    @Nullable
    private OTelSpanKind otelKind = null;
    private final Map<String, Object> otelAttributes = new HashMap<String, Object>();

    public int getReferenceCount() {
        return this.references.get();
    }

    public T requestDiscarding() {
        this.discardRequested = true;
        return (T)this;
    }

    public boolean isDiscarded() {
        return this.discardRequested && this.getTraceContext().isDiscardable();
    }

    public AbstractSpan(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.traceContext = TraceContext.with64BitId(this.tracer);
        boolean selfTimeCollectionEnabled = !WildcardMatcher.isAnyMatch(tracer.getConfig(ReporterConfiguration.class).getDisableMetrics(), "span.self_time");
        boolean breakdownMetricsEnabled = tracer.getConfig(CoreConfiguration.class).isBreakdownMetricsEnabled();
        this.collectBreakdownMetrics = selfTimeCollectionEnabled && breakdownMetricsEnabled;
    }

    public boolean isReferenced() {
        return this.references.get() > 0;
    }

    public boolean isFinished() {
        return this.finished;
    }

    public long getDuration() {
        return this.endTimestamp.get() - this.timestamp.get();
    }

    public long getSelfDuration() {
        return this.getDuration() - this.childDurations.getDuration();
    }

    public double getDurationMs() {
        return (double)this.getDuration() / MS_IN_MICROS;
    }

    public StringBuilder getNameForSerialization() {
        return this.name;
    }

    @Nullable
    public StringBuilder getAndOverrideName(int namePriority) {
        return this.getAndOverrideName(namePriority, true);
    }

    @Nullable
    public StringBuilder getAndOverrideName(int namePriority, boolean overrideIfSamePriority) {
        boolean shouldOverride;
        boolean bl = overrideIfSamePriority ? namePriority >= this.namePriority : (shouldOverride = namePriority > this.namePriority);
        if (shouldOverride) {
            this.namePriority = namePriority;
            this.name.setLength(0);
            return this.name;
        }
        return null;
    }

    public void updateName(Class<?> clazz, String methodName) {
        StringBuilder spanName = this.getAndOverrideName(0);
        if (spanName != null) {
            String className = clazz.getName();
            spanName.append(className, className.lastIndexOf(46) + 1, className.length());
            spanName.append("#").append(methodName);
        }
    }

    public String getNameAsString() {
        return this.name.toString();
    }

    public T appendToName(CharSequence cs) {
        return this.appendToName(cs, 0);
    }

    public T appendToName(CharSequence cs, int priority) {
        if (priority >= this.namePriority) {
            this.name.append(cs);
            this.namePriority = priority;
        }
        return this.thiz();
    }

    public T withName(@Nullable String name) {
        return this.withName(name, 0);
    }

    public T withName(@Nullable String name, int priority) {
        return this.withName(name, priority, true);
    }

    public T withName(@Nullable String name, int priority, boolean overrideIfSamePriority) {
        boolean shouldOverride;
        boolean bl = overrideIfSamePriority ? priority >= this.namePriority : (shouldOverride = priority > this.namePriority);
        if (shouldOverride && name != null && !name.isEmpty()) {
            this.name.setLength(0);
            this.name.append(name);
            this.namePriority = priority;
        }
        return this.thiz();
    }

    public T withType(@Nullable String type) {
        this.type = AbstractSpan.normalizeEmpty(type);
        return this.thiz();
    }

    public T withSync(boolean sync) {
        this.sync = sync;
        return this.thiz();
    }

    @Nullable
    protected static String normalizeEmpty(@Nullable String value) {
        return value == null || value.isEmpty() ? null : value;
    }

    public long getTimestamp() {
        return this.timestamp.get();
    }

    public TraceContext getTraceContext() {
        return this.traceContext;
    }

    public <H, C> boolean addSpanLink(TraceContext.ChildContextCreatorTwoArg<C, HeaderGetter<H, C>> childContextCreator, HeaderGetter<H, C> headerGetter, @Nullable C carrier) {
        if (this.spanLinks.size() == 1000) {
            oneTimeMaxSpanLinksLogger.warn("Span links for {} has reached the allowed maximum ({}). No more spans will be linked.", (Object)this, (Object)1000);
            return false;
        }
        boolean added = false;
        try {
            TraceContext childTraceContext = this.tracer.createSpanLink();
            if (childContextCreator.asChildOf(childTraceContext, carrier, headerGetter)) {
                added = this.spanLinks.add(childTraceContext);
            }
            if (!added) {
                this.tracer.recycle(childTraceContext);
            }
        }
        catch (Exception e) {
            logger.error(String.format("Failed to add span link to %s from header carrier %s and %s", this, carrier, headerGetter.getClass().getName()), e);
        }
        return added;
    }

    public List<TraceContext> getSpanLinks() {
        return this.spanLinks;
    }

    @Override
    public void resetState() {
        this.finished = true;
        this.name.setLength(0);
        this.type = null;
        this.sync = true;
        this.timestamp.set(0L);
        this.endTimestamp.set(0L);
        this.traceContext.resetState();
        this.childDurations.resetState();
        this.references.set(0);
        this.namePriority = 0;
        this.discardRequested = false;
        this.isExit = false;
        this.childIds = null;
        this.outcome = null;
        this.userOutcome = null;
        this.hasCapturedExceptions = false;
        this.bufferedSpan.set(null);
        this.recycleSpanLinks();
        this.otelKind = null;
        this.otelAttributes.clear();
    }

    private void recycleSpanLinks() {
        for (int i = 0; i < this.spanLinks.size(); ++i) {
            this.tracer.recycle(this.spanLinks.get(i));
        }
        this.spanLinks.clear();
    }

    public Span createSpan() {
        return this.createSpan(this.traceContext.getClock().getEpochMicros());
    }

    public Span createSpan(long epochMicros) {
        return this.tracer.startSpan(this, epochMicros);
    }

    @Nullable
    public Span createExitSpan() {
        if (this.isExit()) {
            return null;
        }
        return (Span)this.createSpan().asExit();
    }

    public T asExit() {
        this.isExit = true;
        return (T)this;
    }

    public boolean isExit() {
        return this.isExit;
    }

    @Nullable
    public String captureExceptionAndGetErrorId(long epochMicros, @Nullable Throwable t) {
        if (t != null) {
            this.hasCapturedExceptions = true;
            return this.tracer.captureAndReportException(epochMicros, t, this);
        }
        return null;
    }

    public T captureException(@Nullable Throwable t) {
        if (t != null) {
            this.captureExceptionAndGetErrorId(this.getTraceContext().getClock().getEpochMicros(), t);
        }
        return (T)this;
    }

    public void endExceptionally(@Nullable Throwable t) {
        ((AbstractSpan)this.captureException(t)).end();
    }

    @Nullable
    public String captureExceptionAndGetErrorId(@Nullable Throwable t) {
        return this.captureExceptionAndGetErrorId(this.getTraceContext().getClock().getEpochMicros(), t);
    }

    public void addLabel(String key, String value) {
        if (this.isSampled()) {
            this.getContext().addLabel(key, value);
        }
    }

    public void addLabel(String key, Number value) {
        if (this.isSampled()) {
            this.getContext().addLabel(key, value);
        }
    }

    public void addLabel(String key, Boolean value) {
        if (this.isSampled()) {
            this.getContext().addLabel(key, value);
        }
    }

    public abstract AbstractContext getContext();

    protected void onAfterStart() {
        this.finished = false;
        this.incrementReferences();
    }

    public void end() {
        this.end(this.traceContext.getClock().getEpochMicros());
    }

    public final void end(long epochMicros) {
        if (!this.finished) {
            this.endTimestamp.set(epochMicros);
            if (this.name.length() == 0) {
                this.name.append("unnamed");
            }
            this.childDurations.onSpanEnd(epochMicros);
            this.type = this.normalizeType(this.type);
            this.beforeEnd(epochMicros);
            this.finished = true;
            Span buffered = this.bufferedSpan.get();
            if (buffered != null && this.bufferedSpan.compareAndSet(buffered, null)) {
                this.tracer.endSpan(buffered);
            }
            this.afterEnd();
        } else {
            if (oneTimeDuplicatedEndLogger.isWarnEnabled()) {
                oneTimeDuplicatedEndLogger.warn("End has already been called: " + this, new Throwable());
            } else {
                logger.warn("End has already been called: {}", (Object)this);
                logger.debug("Consecutive AbstractSpan#end() invocation stack trace: ", new Throwable());
            }
            assert (false);
        }
    }

    protected boolean outcomeNotSet() {
        return this.userOutcome == null && this.outcome == null;
    }

    protected boolean hasCapturedExceptions() {
        return this.hasCapturedExceptions;
    }

    protected abstract void beforeEnd(long var1);

    protected abstract void afterEnd();

    public boolean isChildOf(AbstractSpan<?> parent) {
        return this.traceContext.isChildOf(parent.traceContext) || super.hasChildId(this.traceContext.getId());
    }

    private boolean hasChildId(Id spanId) {
        if (this.childIds != null) {
            return this.childIds.contains(spanId.readLong(0));
        }
        return false;
    }

    @Override
    public T activate() {
        this.tracer.activate(this);
        return (T)this;
    }

    @Override
    public T deactivate() {
        this.tracer.deactivate(this);
        return (T)this;
    }

    @Override
    public Scope activateInScope() {
        return this.tracer.activateInScope(this);
    }

    public void setStartTimestamp(long epochMicros) {
        this.timestamp.set(epochMicros);
    }

    public void setStartTimestampNow() {
        this.timestamp.set(this.getTraceContext().getClock().getEpochMicros());
    }

    void onChildStart(long epochMicros) {
        if (this.collectBreakdownMetrics) {
            this.childDurations.onChildStart(epochMicros);
        }
    }

    void onChildEnd(long epochMicros) {
        if (this.collectBreakdownMetrics) {
            this.childDurations.onChildEnd(epochMicros);
        }
    }

    public void incrementReferences() {
        int referenceCount = this.references.incrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("increment references to {} ({})", (Object)this, (Object)referenceCount);
            if (logger.isTraceEnabled()) {
                logger.trace("incrementing references at", new RuntimeException("This is an expected exception. Is just used to record where the reference count has been incremented."));
            }
        }
    }

    public void decrementReferences() {
        int referenceCount = this.references.decrementAndGet();
        if (logger.isDebugEnabled()) {
            logger.debug("decrement references to {} ({})", (Object)this, (Object)referenceCount);
            if (logger.isTraceEnabled()) {
                logger.trace("decrementing references at", new RuntimeException("This is an expected exception. Is just used to record where the reference count has been decremented."));
            }
        }
        if (referenceCount == 0) {
            this.recycle();
        }
    }

    protected abstract void recycle();

    public <C> void propagateTraceContext(C carrier, TextHeaderSetter<C> headerSetter) {
        this.setNonDiscardable();
        this.getTraceContext().propagateTraceContext(carrier, headerSetter);
    }

    public <C> boolean propagateTraceContext(C carrier, BinaryHeaderSetter<C> headerSetter) {
        this.setNonDiscardable();
        return this.getTraceContext().propagateTraceContext(carrier, headerSetter);
    }

    public void setNonDiscardable() {
        this.getTraceContext().setNonDiscardable();
    }

    public boolean isDiscardable() {
        return this.getTraceContext().isDiscardable();
    }

    public boolean isSampled() {
        return this.getTraceContext().isSampled();
    }

    public T withChildIds(@Nullable LongList childIds) {
        this.childIds = childIds;
        return this.thiz();
    }

    @Nullable
    public LongList getChildIds() {
        return this.childIds;
    }

    protected abstract T thiz();

    public Outcome getOutcome() {
        if (this.userOutcome != null) {
            return this.userOutcome;
        }
        return this.outcome != null ? this.outcome : Outcome.UNKNOWN;
    }

    public T withOutcome(Outcome outcome) {
        this.outcome = outcome;
        return this.thiz();
    }

    public T withUserOutcome(Outcome outcome) {
        this.userOutcome = outcome;
        return this.thiz();
    }

    @Override
    public ElasticContext<T> withActiveSpan(AbstractSpan<?> span) {
        return this;
    }

    @Override
    public AbstractSpan<?> getSpan() {
        return this;
    }

    public T withOtelKind(OTelSpanKind kind) {
        this.otelKind = kind;
        return this.thiz();
    }

    @Nullable
    public OTelSpanKind getOtelKind() {
        return this.otelKind;
    }

    public Map<String, Object> getOtelAttributes() {
        return this.otelAttributes;
    }

    @Nullable
    public String getType() {
        return this.type;
    }

    public boolean isSync() {
        return this.sync;
    }

    private String normalizeType(@Nullable String type) {
        if (type == null || type.isEmpty()) {
            return "custom";
        }
        return type;
    }

    private static class ChildDurationTimer
    implements Recyclable {
        private AtomicInteger activeChildren = new AtomicInteger();
        private AtomicLong start = new AtomicLong();
        private AtomicLong duration = new AtomicLong();

        private ChildDurationTimer() {
        }

        void onChildStart(long startTimestamp) {
            if (this.activeChildren.incrementAndGet() == 1) {
                this.start.set(startTimestamp);
            }
        }

        void onChildEnd(long endTimestamp) {
            if (this.activeChildren.decrementAndGet() == 0) {
                this.incrementDuration(endTimestamp);
            }
        }

        void onSpanEnd(long endTimestamp) {
            if (this.activeChildren.getAndSet(0) != 0) {
                this.incrementDuration(endTimestamp);
            }
        }

        private void incrementDuration(long epochMicros) {
            this.duration.addAndGet(epochMicros - this.start.get());
        }

        @Override
        public void resetState() {
            this.activeChildren.set(0);
            this.start.set(0L);
            this.duration.set(0L);
        }

        public long getDuration() {
            return this.duration.get();
        }
    }
}

