/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.metadata;

import co.elastic.apm.agent.common.util.ProcessExecutionUtil;
import co.elastic.apm.agent.configuration.ServerlessConfiguration;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public class SystemInfo {
    private static final Logger logger = LoggerFactory.getLogger(SystemInfo.class);
    private static final String CONTAINER_UID_REGEX = "^[0-9a-fA-F]{64}$";
    private static final String SHORTENED_UUID_PATTERN = "^[0-9a-fA-F]{8}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4}\\-[0-9a-fA-F]{4,}";
    private static final String POD_REGEX = "(?:^/kubepods[\\S]*/pod([^/]+)$)|(?:kubepods[^/]*-pod([^/]+)\\.slice)";
    private final String architecture;
    @Nullable
    private final String configuredHostname;
    @Nullable
    private final String detectedHostname;
    private final String platform;
    @Nullable
    private Container container;
    @Nullable
    private Kubernetes kubernetes;

    public SystemInfo(String architecture, @Nullable String configuredHostname, @Nullable String detectedHostname, String platform) {
        this(architecture, configuredHostname, detectedHostname, platform, null, null);
    }

    SystemInfo(String architecture, @Nullable String configuredHostname, @Nullable String detectedHostname, String platform, @Nullable Container container, @Nullable Kubernetes kubernetes) {
        this.architecture = architecture;
        this.configuredHostname = configuredHostname;
        this.detectedHostname = detectedHostname;
        this.platform = platform;
        this.container = container;
        this.kubernetes = kubernetes;
    }

    public static SystemInfo create(@Nullable String configuredHostname, long timeoutMillis, ServerlessConfiguration serverlessConfiguration) {
        SystemInfo systemInfo;
        String osName = System.getProperty("os.name");
        String osArch = System.getProperty("os.arch");
        if (serverlessConfiguration.runsOnAwsLambda()) {
            return new SystemInfo(osArch, null, null, osName);
        }
        if (configuredHostname != null && !configuredHostname.isEmpty()) {
            systemInfo = new SystemInfo(osArch, configuredHostname, null, osName);
        } else {
            String detectedHostname = SystemInfo.discoverHostname(SystemInfo.isWindows(osName), timeoutMillis);
            systemInfo = new SystemInfo(osArch, configuredHostname, detectedHostname, osName);
        }
        systemInfo.findContainerDetails();
        return systemInfo;
    }

    static boolean isWindows(String osName) {
        return osName.startsWith("Windows");
    }

    @Nullable
    static String discoverHostname(boolean isWindows, long timeoutMillis) {
        String hostname = SystemInfo.discoverHostnameThroughCommand(isWindows, timeoutMillis);
        if (hostname == null || hostname.isEmpty()) {
            hostname = SystemInfo.fallbackHostnameDiscovery(isWindows);
        }
        if (hostname == null || hostname.isEmpty()) {
            logger.warn("Unable to discover hostname, set log_level to debug for more details");
        }
        return hostname;
    }

    @Nullable
    static String fallbackHostnameDiscovery(boolean isWindows) {
        String hostname = SystemInfo.discoverHostnameThroughEnv(isWindows);
        if (hostname == null || hostname.isEmpty()) {
            try {
                hostname = InetAddress.getLocalHost().getHostName();
                if (hostname != null) {
                    hostname = SystemInfo.removeDomain(hostname);
                }
            }
            catch (Exception e) {
                logger.warn("Last fallback for hostname discovery of localhost failed", e);
            }
        }
        return hostname;
    }

    @Nullable
    static String discoverHostnameThroughCommand(boolean isWindows, long timeoutMillis) {
        String hostname;
        if (isWindows) {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("cmd");
            cmd.add("/c");
            cmd.add("hostname");
            hostname = SystemInfo.executeHostnameDiscoveryCommand(cmd, timeoutMillis);
        } else {
            ArrayList<String> cmd = new ArrayList<String>();
            cmd.add("uname");
            cmd.add("-n");
            hostname = SystemInfo.executeHostnameDiscoveryCommand(cmd, timeoutMillis);
            if (hostname == null || hostname.isEmpty()) {
                cmd = new ArrayList();
                cmd.add("hostname");
                hostname = SystemInfo.executeHostnameDiscoveryCommand(cmd, timeoutMillis);
            }
        }
        return hostname;
    }

    @Nullable
    private static String executeHostnameDiscoveryCommand(List<String> cmd, long timeoutMillis) {
        String hostname = null;
        ProcessExecutionUtil.CommandOutput commandOutput = ProcessExecutionUtil.executeCommand(cmd, timeoutMillis);
        if (commandOutput.exitedNormally()) {
            hostname = commandOutput.getOutput().toString().trim();
            if (logger.isDebugEnabled()) {
                logger.debug("hostname obtained by executing command {}: {}", (Object)ProcessExecutionUtil.cmdAsString(cmd), (Object)hostname);
            }
        } else {
            logger.info("Failed to execute command {} with exit code {}", (Object)ProcessExecutionUtil.cmdAsString(cmd), (Object)commandOutput.getExitCode());
            logger.debug("Command execution error", commandOutput.getExceptionThrown());
        }
        return hostname;
    }

    @Nullable
    static String discoverHostnameThroughEnv(boolean isWindows) {
        String hostname;
        if (isWindows) {
            hostname = System.getenv("COMPUTERNAME");
        } else {
            hostname = System.getenv("HOSTNAME");
            if (hostname == null || hostname.isEmpty()) {
                hostname = System.getenv("HOST");
            }
        }
        return hostname;
    }

    static String removeDomain(String hostname) {
        int indexOfDot = hostname.indexOf(46);
        if (indexOfDot > 0) {
            hostname = hostname.substring(0, indexOfDot);
        }
        return hostname;
    }

    SystemInfo findContainerDetails() {
        String containerId;
        block7: {
            containerId = null;
            try {
                Path path = FileSystems.getDefault().getPath("/proc/self/cgroup", new String[0]);
                if (!path.toFile().exists()) break block7;
                List<String> lines = Files.readAllLines(path, StandardCharsets.UTF_8);
                for (String line : lines) {
                    this.parseContainerId(line);
                    if (this.container == null) continue;
                    containerId = this.container.getId();
                    break;
                }
            }
            catch (Throwable e) {
                logger.warn("Failed to read/parse container ID from '/proc/self/cgroup'", e);
            }
        }
        try {
            String podUid = System.getenv("KUBERNETES_POD_UID");
            String podName = System.getenv("KUBERNETES_POD_NAME");
            String nodeName = System.getenv("KUBERNETES_NODE_NAME");
            String namespace = System.getenv("KUBERNETES_NAMESPACE");
            if (podUid != null || podName != null || nodeName != null || namespace != null) {
                if (this.kubernetes != null && this.kubernetes.getPod() != null) {
                    podUid = podUid != null ? podUid : this.kubernetes.getPod().getUid();
                    podName = podName != null ? podName : this.kubernetes.getPod().getName();
                }
                this.kubernetes = new Kubernetes(podName, nodeName, namespace, podUid);
            }
        }
        catch (Throwable e) {
            logger.warn("Failed to read environment variables for Kubernetes Downward API discovery", e);
        }
        logger.debug("container ID is {}", (Object)containerId);
        return this;
    }

    SystemInfo parseContainerId(String line) {
        String[] fields = line.split(":", 3);
        if (fields.length == 3) {
            String cGroupPath = fields[2];
            int indexOfIdSeparator = cGroupPath.lastIndexOf(58);
            if (indexOfIdSeparator < 0) {
                indexOfIdSeparator = cGroupPath.lastIndexOf(47);
            }
            if (indexOfIdSeparator >= 0) {
                Pattern pattern;
                Matcher matcher;
                String dir;
                String idPart = cGroupPath.substring(indexOfIdSeparator + 1);
                if (idPart.endsWith(".scope")) {
                    idPart = idPart.substring(0, idPart.length() - ".scope".length()).substring(idPart.indexOf("-") + 1);
                }
                if ((dir = cGroupPath.substring(0, indexOfIdSeparator)).length() > 0 && (matcher = (pattern = Pattern.compile(POD_REGEX)).matcher(dir)).find()) {
                    for (int i = 1; i <= matcher.groupCount(); ++i) {
                        String podUid = matcher.group(i);
                        if (podUid == null || podUid.isEmpty()) continue;
                        podUid = podUid.replace('_', '-');
                        logger.debug("Found Kubernetes pod UID: {}", (Object)podUid);
                        this.kubernetes = new Kubernetes(this.getHostname(), null, null, podUid);
                        break;
                    }
                }
                if (this.kubernetes != null || idPart.matches(CONTAINER_UID_REGEX) || idPart.matches(SHORTENED_UUID_PATTERN)) {
                    this.container = new Container(idPart);
                }
            }
        }
        if (this.container == null) {
            logger.debug("Could not parse container ID from '/proc/self/cgroup' line: {}", (Object)line);
        }
        return this;
    }

    public String getArchitecture() {
        return this.architecture;
    }

    @Deprecated
    public String getHostname() {
        if (this.configuredHostname != null && !this.configuredHostname.isEmpty()) {
            return this.configuredHostname;
        }
        if (this.detectedHostname != null && !this.detectedHostname.isEmpty()) {
            return this.detectedHostname;
        }
        return "<unknown>";
    }

    @Nullable
    public String getConfiguredHostname() {
        return this.configuredHostname;
    }

    @Nullable
    public String getDetectedHostname() {
        return this.detectedHostname;
    }

    public String getPlatform() {
        return this.platform;
    }

    @Nullable
    public Container getContainerInfo() {
        return this.container;
    }

    @Nullable
    public Kubernetes getKubernetesInfo() {
        return this.kubernetes;
    }

    public static class Kubernetes {
        @Nullable
        Pod pod;
        @Nullable
        Node node;
        @Nullable
        private String namespace;

        Kubernetes(@Nullable String podName, @Nullable String nodeName, @Nullable String namespace, @Nullable String podUid) {
            if (podName != null || podUid != null) {
                this.pod = new Pod(podName, podUid);
            }
            if (nodeName != null) {
                this.node = new Node(nodeName);
            }
            this.namespace = namespace;
        }

        @Nullable
        public Pod getPod() {
            return this.pod;
        }

        @Nullable
        public Node getNode() {
            return this.node;
        }

        @Nullable
        public String getNamespace() {
            return this.namespace;
        }

        public boolean hasContent() {
            return this.pod != null || this.node != null || this.namespace != null;
        }

        public static class Node {
            private String name;

            Node(String name) {
                this.name = name;
            }

            public String getName() {
                return this.name;
            }
        }

        public static class Pod {
            @Nullable
            private String name;
            @Nullable
            private String uid;

            Pod(@Nullable String name, @Nullable String uid) {
                this.name = name;
                this.uid = uid;
            }

            @Nullable
            public String getName() {
                return this.name;
            }

            @Nullable
            public String getUid() {
                return this.uid;
            }
        }
    }

    public static class Container {
        private String id;

        Container(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }
    }
}

