/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.metadata;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.ServerlessConfiguration;
import co.elastic.apm.agent.impl.metadata.CloudProviderInfo;
import co.elastic.apm.agent.impl.metadata.NameAndIdField;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.ExecutorUtils;
import co.elastic.apm.agent.util.UrlConnectionUtils;
import com.dslplatform.json.DslJson;
import com.dslplatform.json.JsonReader;
import com.dslplatform.json.ObjectConverter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;

public class CloudMetadataProvider {
    private static final Logger logger = LoggerFactory.getLogger(CloudMetadataProvider.class);
    private static final DslJson<Object> dslJson = new DslJson(new DslJson.Settings());

    @Nullable
    static CloudProviderInfo getCloudInfoProvider(CoreConfiguration.CloudProvider cloudProvider, int queryTimeoutMs, ServerlessConfiguration serverlessConfiguration) {
        if (serverlessConfiguration.runsOnAwsLambda()) {
            CloudProviderInfo awsLambdaInfo = new CloudProviderInfo("aws");
            awsLambdaInfo.setRegion(System.getenv("AWS_REGION"));
            awsLambdaInfo.setService(new CloudProviderInfo.Service("lambda"));
            return awsLambdaInfo;
        }
        if (cloudProvider == CoreConfiguration.CloudProvider.NONE) {
            return null;
        }
        return CloudMetadataProvider.fetchAndParseCloudProviderInfo(cloudProvider, queryTimeoutMs);
    }

    @Nullable
    static CloudProviderInfo fetchAndParseCloudProviderInfo(CoreConfiguration.CloudProvider cloudProvider, int queryTimeoutMs) {
        Throwable unexpectedError = null;
        CloudProviderInfo cloudProviderInfo = null;
        try {
            switch (cloudProvider) {
                case AWS: {
                    try {
                        cloudProviderInfo = CloudMetadataProvider.getAwsMetadata(queryTimeoutMs, cloudProvider);
                    }
                    catch (Exception e) {
                        unexpectedError = e;
                    }
                    break;
                }
                case GCP: {
                    try {
                        cloudProviderInfo = CloudMetadataProvider.getGcpMetadata(queryTimeoutMs);
                    }
                    catch (Exception e) {
                        unexpectedError = e;
                    }
                    break;
                }
                case AZURE: {
                    try {
                        cloudProviderInfo = CloudMetadataProvider.getAzureMetadata(queryTimeoutMs);
                    }
                    catch (Exception e) {
                        unexpectedError = e;
                    }
                    break;
                }
                case AUTO: {
                    cloudProviderInfo = CloudMetadataProvider.tryAllCloudProviders(cloudProvider, queryTimeoutMs);
                }
            }
        }
        catch (Throwable throwable) {
            unexpectedError = throwable;
        }
        CloudMetadataProvider.logSummary(cloudProvider, cloudProviderInfo, unexpectedError);
        return cloudProviderInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static CloudProviderInfo tryAllCloudProviders(final CoreConfiguration.CloudProvider cloudProvider, final int queryTimeoutMs) throws InterruptedException, ExecutionException, TimeoutException {
        Future<CloudProviderInfo> gcpMetadata;
        Future<CloudProviderInfo> awsMetadata;
        ThreadPoolExecutor executor = ExecutorUtils.createThreadDaemonPool("cloud-metadata", 2, 2);
        CloudProviderInfo cloudProviderInfo = null;
        try {
            awsMetadata = executor.submit(new Callable<CloudProviderInfo>(){

                @Override
                @Nullable
                public CloudProviderInfo call() {
                    CloudProviderInfo awsInfo = null;
                    try {
                        awsInfo = CloudMetadataProvider.getAwsMetadata(queryTimeoutMs, cloudProvider);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return awsInfo;
                }
            });
            gcpMetadata = executor.submit(new Callable<CloudProviderInfo>(){

                @Override
                @Nullable
                public CloudProviderInfo call() {
                    CloudProviderInfo gcpInfo = null;
                    try {
                        gcpInfo = CloudMetadataProvider.getGcpMetadata(queryTimeoutMs);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return gcpInfo;
                }
            });
        }
        finally {
            executor.shutdown();
        }
        long futureTimeout = queryTimeoutMs + 200;
        try {
            cloudProviderInfo = CloudMetadataProvider.getAzureMetadata(queryTimeoutMs);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (cloudProviderInfo == null) {
            cloudProviderInfo = awsMetadata.get(futureTimeout, TimeUnit.MILLISECONDS);
        }
        if (cloudProviderInfo == null) {
            cloudProviderInfo = gcpMetadata.get(futureTimeout, TimeUnit.MILLISECONDS);
        }
        return cloudProviderInfo;
    }

    private static void logSummary(CoreConfiguration.CloudProvider cloudProvider, @Nullable CloudProviderInfo cloudProviderInfo, @Nullable Throwable unexpectedError) {
        if (cloudProviderInfo == null) {
            if (cloudProvider == CoreConfiguration.CloudProvider.AWS || cloudProvider == CoreConfiguration.CloudProvider.AZURE || cloudProvider == CoreConfiguration.CloudProvider.GCP) {
                String msg = cloudProvider.name() + " is defined as the cloud_provider, but no metadata was found where expected";
                if (unexpectedError != null) {
                    logger.warn(msg, unexpectedError);
                } else {
                    logger.warn(msg);
                }
            } else if (unexpectedError != null) {
                logger.warn("Unexpected error during automatic discovery process for cloud provider", unexpectedError);
            } else {
                logger.debug("cloud_provider configured {}, no cloud metadata discovered", (Object)cloudProvider);
            }
        } else {
            logger.debug("Cloud metadata discovered: {}", (Object)cloudProviderInfo);
        }
    }

    @Nullable
    private static CloudProviderInfo getAwsMetadata(int queryTimeoutMs, CoreConfiguration.CloudProvider configuredProvider) throws IOException {
        String token;
        block3: {
            String awsTokenUrl = "http://169.254.169.254/latest/api/token";
            HashMap<String, String> headers = new HashMap<String, String>(1);
            headers.put("X-aws-ec2-metadata-token-ttl-seconds", "300");
            token = null;
            try {
                token = CloudMetadataProvider.executeRequest(awsTokenUrl, "PUT", headers, queryTimeoutMs);
                logger.debug("Got aws token with a length of {} characters", (Object)token.length());
            }
            catch (Exception e) {
                if (configuredProvider != CoreConfiguration.CloudProvider.AWS) break block3;
                logger.info("Unable to obtain API token, probably because running within a Docker container. This means that AWS metadata may not be available.");
            }
        }
        String awsMetadataUrl = "http://169.254.169.254/latest/dynamic/instance-identity/document";
        HashMap<String, String> documentHeaders = null;
        if (token != null) {
            documentHeaders = new HashMap<String, String>(1);
            documentHeaders.put("X-aws-ec2-metadata-token", token);
        }
        String metadata = CloudMetadataProvider.executeRequest(awsMetadataUrl, "GET", documentHeaders, queryTimeoutMs);
        logger.debug("AWS metadata retrieved");
        return CloudMetadataProvider.deserializeAwsMetadata(metadata);
    }

    @Nullable
    static CloudProviderInfo deserializeAwsMetadata(@Nullable String rawMetadata) throws IOException {
        if (rawMetadata == null) {
            return null;
        }
        Map<String, Object> map = CloudMetadataProvider.deserialize(rawMetadata);
        Object accountIdValue = map.get("accountId");
        String accountId = accountIdValue instanceof String ? (String)accountIdValue : null;
        Object instanceIdValue = map.get("instanceId");
        String instanceId = instanceIdValue instanceof String ? (String)instanceIdValue : null;
        Object instanceTypeValue = map.get("instanceType");
        String instanceType = instanceTypeValue instanceof String ? (String)instanceTypeValue : null;
        Object availabilityZoneValue = map.get("availabilityZone");
        String availabilityZone = availabilityZoneValue instanceof String ? (String)availabilityZoneValue : null;
        Object regionValue = map.get("region");
        String region = regionValue instanceof String ? (String)regionValue : null;
        CloudProviderInfo cloudProviderInfo = new CloudProviderInfo("aws");
        if (instanceType != null) {
            cloudProviderInfo.setMachine(new CloudProviderInfo.ProviderMachine(instanceType));
        }
        cloudProviderInfo.setInstance(new NameAndIdField(null, instanceId));
        cloudProviderInfo.setAvailabilityZone(availabilityZone);
        cloudProviderInfo.setAccount(new CloudProviderInfo.ProviderAccount(accountId));
        cloudProviderInfo.setRegion(region);
        cloudProviderInfo.setService(new CloudProviderInfo.Service("ec2"));
        return cloudProviderInfo;
    }

    @Nullable
    private static CloudProviderInfo getGcpMetadata(int queryTimeoutMs) throws IOException {
        String gcpUrl = "http://metadata.google.internal/computeMetadata/v1/?recursive=true";
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("Metadata-Flavor", "Google");
        String metadata = CloudMetadataProvider.executeRequest(gcpUrl, "GET", headers, queryTimeoutMs);
        logger.debug("GCP metadata retrieved");
        return CloudMetadataProvider.deserializeGcpMetadata(metadata);
    }

    @Nullable
    static CloudProviderInfo deserializeGcpMetadata(@Nullable String rawMetadata) throws IOException {
        if (rawMetadata == null) {
            return null;
        }
        Map<String, Object> map = CloudMetadataProvider.deserialize(rawMetadata);
        CloudProviderInfo cloudProviderInfo = new CloudProviderInfo("gcp");
        Object instanceData = map.get("instance");
        if (instanceData instanceof Map) {
            String machineType;
            Map instanceMap = (Map)instanceData;
            Long instanceId = instanceMap.get("id") instanceof Long ? (Long)instanceMap.get("id") : null;
            String instanceName = instanceMap.get("name") instanceof String ? (String)instanceMap.get("name") : null;
            String zone = instanceMap.get("zone") instanceof String ? (String)instanceMap.get("zone") : null;
            cloudProviderInfo.setInstance(new NameAndIdField(instanceName, instanceId));
            String string = machineType = instanceMap.get("machineType") instanceof String ? (String)instanceMap.get("machineType") : null;
            if (machineType != null) {
                String[] machinePathParts = machineType.split("/");
                cloudProviderInfo.setMachine(new CloudProviderInfo.ProviderMachine(machinePathParts[machinePathParts.length - 1]));
            }
            if (zone != null) {
                String[] zoneParts = zone.split("/");
                String availabilityZone = zoneParts[zoneParts.length - 1];
                cloudProviderInfo.setAvailabilityZone(availabilityZone);
                int hyphenLastIndex = availabilityZone.lastIndexOf("-");
                cloudProviderInfo.setRegion(hyphenLastIndex != -1 ? availabilityZone.substring(0, hyphenLastIndex) : null);
            }
        } else {
            logger.warn("Error while parsing GCP metadata - expecting the value of the 'instance' entry to be a map but it is not");
        }
        Object projectData = map.get("project");
        if (projectData instanceof Map) {
            Map projectMap = (Map)projectData;
            String projectId = projectMap.get("projectId") instanceof String ? (String)projectMap.get("projectId") : null;
            Long numericProjectId = projectMap.get("numericProjectId") instanceof Long ? (Long)projectMap.get("numericProjectId") : null;
            cloudProviderInfo.setProject(new NameAndIdField(projectId, numericProjectId));
        } else {
            logger.warn("Error while parsing GCP metadata - expecting the value of the 'project' entry to be a map but it is not");
        }
        return cloudProviderInfo;
    }

    @Nullable
    private static CloudProviderInfo getAzureMetadata(int queryTimeoutMs) throws IOException {
        String azureUrl = "http://169.254.169.254/metadata/instance/compute?api-version=2019-08-15";
        HashMap<String, String> headers = new HashMap<String, String>(1);
        headers.put("Metadata", "true");
        String metadata = CloudMetadataProvider.executeRequest(azureUrl, "GET", headers, queryTimeoutMs);
        logger.debug("Azure metadata retrieved");
        return CloudMetadataProvider.deserializeAzureMetadata(metadata);
    }

    @Nullable
    static CloudProviderInfo deserializeAzureMetadata(@Nullable String rawMetadata) throws IOException {
        if (rawMetadata == null) {
            return null;
        }
        Map<String, Object> map = CloudMetadataProvider.deserialize(rawMetadata);
        Object subscriptionIdValue = map.get("subscriptionId");
        String subscriptionId = subscriptionIdValue instanceof String ? (String)subscriptionIdValue : null;
        Object vmIdValue = map.get("vmId");
        String vmId = vmIdValue instanceof String ? (String)vmIdValue : null;
        Object nameValue = map.get("name");
        String vmName = nameValue instanceof String ? (String)nameValue : null;
        Object resourceGroupNameValue = map.get("resourceGroupName");
        String resourceGroupName = resourceGroupNameValue instanceof String ? (String)resourceGroupNameValue : null;
        Object zoneValue = map.get("zone");
        String zone = zoneValue instanceof String ? (String)zoneValue : null;
        Object vmSizeValue = map.get("vmSize");
        String vmSize = vmSizeValue instanceof String ? (String)vmSizeValue : null;
        Object locationValue = map.get("location");
        String location = locationValue instanceof String ? (String)locationValue : null;
        CloudProviderInfo cloudProviderInfo = new CloudProviderInfo("azure");
        cloudProviderInfo.setAccount(new CloudProviderInfo.ProviderAccount(subscriptionId));
        cloudProviderInfo.setInstance(new NameAndIdField(vmName, vmId));
        cloudProviderInfo.setProject(new NameAndIdField(resourceGroupName));
        cloudProviderInfo.setAvailabilityZone(zone);
        if (vmSize != null) {
            cloudProviderInfo.setMachine(new CloudProviderInfo.ProviderMachine(vmSize));
        }
        cloudProviderInfo.setRegion(location);
        return cloudProviderInfo;
    }

    private static Map<String, Object> deserialize(String input) throws IOException {
        JsonReader<Object> reader = dslJson.newReader(input.getBytes(StandardCharsets.UTF_8));
        reader.startObject();
        return (Map)ObjectConverter.deserializeObject(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String executeRequest(String url, String method, @Nullable Map<String, String> headers, int queryTimeoutMs) throws IOException {
        String response;
        HttpURLConnection urlConnection = (HttpURLConnection)UrlConnectionUtils.openUrlConnectionThreadSafely(new URL(url));
        if (headers != null) {
            for (String header : headers.keySet()) {
                urlConnection.setRequestProperty(header, headers.get(header));
            }
        }
        urlConnection.setRequestMethod(method);
        urlConnection.setReadTimeout(queryTimeoutMs);
        urlConnection.setConnectTimeout(queryTimeoutMs);
        try (BufferedReader in = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));){
            String inputLine;
            StringBuilder content = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                content.append(inputLine);
            }
            response = content.toString();
        }
        finally {
            urlConnection.disconnect();
        }
        return response;
    }
}

