/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context.web;

import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcherValueConverter;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;
import org.stagemonitor.configuration.converter.ListValueConverter;

public class WebConfiguration
extends ConfigurationOptionProvider {
    private static final String HTTP_CATEGORY = "HTTP";
    private final ConfigurationOption<List<WildcardMatcher>> captureContentTypes = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("capture_body_content_types").configurationCategory("HTTP").tags("added[1.5.0]", "performance").description("Configures which content types should be recorded.\n\nThe defaults end with a wildcard so that content types like `text/plain; charset=utf-8` are captured as well.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("application/x-www-form-urlencoded*"), WildcardMatcher.valueOf("text/*"), WildcardMatcher.valueOf("application/json*"), WildcardMatcher.valueOf("application/xml*")));
    private final ConfigurationOption<List<WildcardMatcher>> ignoreUrls = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("transaction_ignore_urls").aliasKeys("ignore_urls").configurationCategory("HTTP").description("Used to restrict requests to certain URLs from being instrumented.\n\nThis property should be set to an array containing one or more strings.\nWhen an incoming HTTP request is detected, its URL will be tested against each element in this list.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("/VAADIN/*"), WildcardMatcher.valueOf("/heartbeat*"), WildcardMatcher.valueOf("/favicon.ico"), WildcardMatcher.valueOf("*.js"), WildcardMatcher.valueOf("*.css"), WildcardMatcher.valueOf("*.jpg"), WildcardMatcher.valueOf("*.jpeg"), WildcardMatcher.valueOf("*.png"), WildcardMatcher.valueOf("*.gif"), WildcardMatcher.valueOf("*.webp"), WildcardMatcher.valueOf("*.svg"), WildcardMatcher.valueOf("*.woff"), WildcardMatcher.valueOf("*.woff2")));
    private final ConfigurationOption<List<WildcardMatcher>> ignoreUserAgents = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("transaction_ignore_user_agents").aliasKeys("ignore_user_agents").tags("added[1.22.0]").configurationCategory("HTTP").description("Used to restrict requests from certain User-Agents from being instrumented.\n\nWhen an incoming HTTP request is detected,\nthe User-Agent from the request headers will be tested against each element in this list.\nExample: `curl/*`, `*pingdom*`\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<Boolean> usePathAsName = ConfigurationOption.booleanOption().key("use_path_as_transaction_name").configurationCategory("HTTP").tags("added[1.0.0,Changing this value at runtime is possible since version 1.22.0]").description("If set to `true`,\ntransaction names of unsupported or partially-supported frameworks will be in the form of `$method $path` instead of just `$method unknown route`.\n\nWARNING: If your URLs contain path parameters like `/user/$userId`,\nyou should be very careful when enabling this flag,\nas it can lead to an explosion of transaction groups.\nTake a look at the `url_groups` option on how to mitigate this problem by grouping URLs together.").dynamic(true).buildWithDefault(false);
    private final ConfigurationOption<List<WildcardMatcher>> urlGroups = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("url_groups").configurationCategory("HTTP").description("This option is only considered, when `use_path_as_transaction_name` is active.\n\nWith this option, you can group several URL paths together by using a wildcard expression like `/user/*`.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Collections.emptyList());

    public List<WildcardMatcher> getIgnoreUrls() {
        return this.ignoreUrls.get();
    }

    public List<WildcardMatcher> getIgnoreUserAgents() {
        return this.ignoreUserAgents.get();
    }

    public boolean isUsePathAsName() {
        return this.usePathAsName.get();
    }

    public List<WildcardMatcher> getUrlGroups() {
        return this.urlGroups.get();
    }

    public List<WildcardMatcher> getCaptureContentTypes() {
        return this.captureContentTypes.get();
    }
}

