/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.context;

import co.elastic.apm.agent.objectpool.Recyclable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import javax.annotation.Nullable;

public class Url
implements Recyclable {
    private final StringBuilder full = new StringBuilder();
    @Nullable
    private String protocol;
    @Nullable
    private String hostname;
    private int port = -1;
    @Nullable
    private String pathname;
    @Nullable
    private String search;

    @Nullable
    public String getProtocol() {
        return this.protocol;
    }

    public Url withProtocol(@Nullable String protocol) {
        this.protocol = protocol;
        return this;
    }

    public StringBuilder getFull() {
        if (this.full.length() == 0 && this.hasContent()) {
            this.updateFull();
        }
        return this.full;
    }

    private void updateFull() {
        int portValue = Url.normalizePort(this.port, this.protocol);
        this.full.setLength(0);
        this.full.append(this.protocol);
        this.full.append("://");
        this.full.append(this.hostname);
        if (Url.isHttps(this.protocol) && portValue != 443 || Url.isHttp(this.protocol) && portValue != 80) {
            this.full.append(':').append(portValue);
        }
        if (this.pathname != null) {
            this.full.append(this.pathname);
        }
        if (this.search != null) {
            this.full.append('?').append(this.search);
        }
    }

    public Url withFull(CharSequence value) {
        if (!Url.urlNeedsSanitization(value)) {
            this.full.setLength(0);
            this.full.append(value);
        } else {
            String uriStringValue = value.toString();
            URI uri = null;
            try {
                uri = new URI(uriStringValue);
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
            if (uri != null) {
                this.fillFrom(uri);
            }
        }
        return this;
    }

    private static boolean urlNeedsSanitization(CharSequence sequence) {
        for (int i = 0; i < sequence.length(); ++i) {
            if (sequence.charAt(i) != '@') continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    public Url withHostname(@Nullable String hostname) {
        this.hostname = hostname;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public Url withPort(int port) {
        this.port = port;
        return this;
    }

    @Nullable
    public String getPathname() {
        return this.pathname;
    }

    public Url withPathname(@Nullable String pathname) {
        this.pathname = pathname;
        return this;
    }

    @Nullable
    public String getSearch() {
        return this.search;
    }

    public Url withSearch(@Nullable String search) {
        this.search = search;
        return this;
    }

    public void fillFrom(URI uri) {
        this.withProtocol(uri.getScheme()).withHostname(uri.getHost()).withPort(Url.normalizePort(uri.getPort(), uri.getScheme())).withPathname(uri.getPath()).withSearch(uri.getQuery()).updateFull();
    }

    public void fillFrom(URL url) {
        int port = url.getPort();
        if (port < 0) {
            port = url.getDefaultPort();
        }
        this.withProtocol(url.getProtocol()).withHostname(url.getHost()).withPort(port).withPathname(url.getPath()).withSearch(url.getQuery()).updateFull();
    }

    @Deprecated
    public void fillFrom(CharSequence uriString) {
        this.full.setLength(0);
        this.full.append(uriString);
    }

    public void parseAndFillFromFull() {
        if (this.full.length() > 0) {
            try {
                this.fillFrom(new URL(this.full.toString()));
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
    }

    public static int normalizePort(int port, @Nullable String protocol) {
        int portValue = port;
        if (portValue < 0 && protocol != null) {
            portValue = Url.isHttps(protocol) ? 443 : (Url.isHttp(protocol) ? 80 : portValue);
        }
        return portValue;
    }

    private static boolean isHttps(@Nullable String protocol) {
        return "https".equals(protocol);
    }

    private static boolean isHttp(@Nullable String protocol) {
        return "http".equals(protocol);
    }

    @Override
    public void resetState() {
        this.protocol = null;
        this.full.setLength(0);
        this.hostname = null;
        this.port = -1;
        this.pathname = null;
        this.search = null;
    }

    public void copyFrom(Url other) {
        this.protocol = other.protocol;
        this.full.setLength(0);
        this.full.append((CharSequence)other.full);
        this.hostname = other.hostname;
        this.port = other.port;
        this.pathname = other.pathname;
        this.search = other.search;
    }

    public boolean hasContent() {
        return this.protocol != null || this.full.length() > 0 || this.hostname != null || this.port >= 0 || this.pathname != null || this.search != null;
    }
}

