/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.impl.circuitbreaker;

import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.circuitbreaker.StressMonitor;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.JmxUtils;
import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

public class SystemCpuStressMonitor
extends StressMonitor {
    private static final Logger logger = LoggerFactory.getLogger(SystemCpuStressMonitor.class);
    private final StringBuilder latestStressDetectionInfo = new StringBuilder("No stress has been detected so far.");
    private final OperatingSystemMXBean operatingSystemBean = ManagementFactory.getOperatingSystemMXBean();
    private int consecutiveMeasurementsAboveStressThreshold;
    private int consecutiveMeasurementsBelowReliefThreshold;
    private boolean currentlyUnderStress;
    @Nullable
    private final Method systemCpuUsageMethod = JmxUtils.getOperatingSystemMBeanMethod(this.operatingSystemBean, "getSystemCpuLoad");

    SystemCpuStressMonitor(ElasticApmTracer tracer) {
        super(tracer);
        if (this.systemCpuUsageMethod != null) {
            logger.debug("Successfully obtained reference to the getSystemCpuLoad method of this JVM's OperatingSystemMXBean implementation");
        } else {
            logger.warn("Failed to obtain reference to the getSystemCpuLoad method of this JVM's OperatingSystemMXBean implementation");
        }
    }

    @Nullable
    Method getGetSystemCpuLoadMethod() {
        return this.systemCpuUsageMethod;
    }

    OperatingSystemMXBean getOperatingSystemBean() {
        return this.operatingSystemBean;
    }

    @Override
    boolean isUnderStress() throws Exception {
        this.readAndCompareToThresholds();
        return this.currentlyUnderStress;
    }

    @Override
    boolean isStressRelieved() throws Exception {
        this.readAndCompareToThresholds();
        return !this.currentlyUnderStress;
    }

    private void readAndCompareToThresholds() throws InvocationTargetException, IllegalAccessException {
        Method mbeanMethodImpl = this.getGetSystemCpuLoadMethod();
        if (mbeanMethodImpl != null) {
            double systemCpuValue = ((Number)mbeanMethodImpl.invoke((Object)this.getOperatingSystemBean(), new Object[0])).doubleValue();
            if (!Double.isNaN(systemCpuValue) && !Double.isInfinite(systemCpuValue)) {
                logger.debug("System CPU measurement: {}", (Object)systemCpuValue);
                int cpuConsecutiveMeasurements = (int)(this.circuitBreakerConfiguration.getCpuStressDurationThresholdMillis() / this.circuitBreakerConfiguration.getStressMonitoringPollingIntervalMillis());
                if (systemCpuValue > this.circuitBreakerConfiguration.getSystemCpuStressThreshold()) {
                    ++this.consecutiveMeasurementsAboveStressThreshold;
                    if (this.consecutiveMeasurementsAboveStressThreshold == cpuConsecutiveMeasurements) {
                        this.currentlyUnderStress = true;
                        this.latestStressDetectionInfo.setLength(0);
                        this.latestStressDetectionInfo.append("Latest system CPU load value measured is ").append(systemCpuValue).append(". This is the ").append(cpuConsecutiveMeasurements).append("th consecutive measurement that crossed the configured stress threshold - ").append(this.circuitBreakerConfiguration.getSystemCpuStressThreshold()).append(", which indicates this host is under CPU stress.");
                    }
                } else {
                    this.consecutiveMeasurementsAboveStressThreshold = 0;
                }
                if (systemCpuValue < this.circuitBreakerConfiguration.getSystemCpuReliefThreshold()) {
                    ++this.consecutiveMeasurementsBelowReliefThreshold;
                    if (this.consecutiveMeasurementsBelowReliefThreshold == cpuConsecutiveMeasurements) {
                        this.currentlyUnderStress = false;
                        logger.info("Latest system CPU load value measured is {}. This is {}th consecutive measurement that is below the configured relief threshold - {}", systemCpuValue, cpuConsecutiveMeasurements, this.circuitBreakerConfiguration.getSystemCpuReliefThreshold());
                    }
                } else {
                    this.consecutiveMeasurementsBelowReliefThreshold = 0;
                }
            } else {
                logger.debug("Latest measurement of system CPU load produced an invalid value: {}", (Object)systemCpuValue);
            }
        }
    }

    @Override
    String getStressDetectionInfo() {
        return this.latestStressDetectionInfo.toString();
    }
}

