/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpserver;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.httpserver.CookieHelper;
import co.elastic.apm.agent.httpserver.HeadersHeaderGetter;
import co.elastic.apm.agent.httpserver.HttpServerHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.Request;
import co.elastic.apm.agent.impl.context.Response;
import co.elastic.apm.agent.impl.context.web.ResultUtil;
import co.elastic.apm.agent.impl.context.web.WebConfiguration;
import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.TransactionNameUtils;
import com.sun.net.httpserver.Headers;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpsExchange;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;

public class HttpHandlerAdvice {
    private static final Logger logger = LoggerFactory.getLogger(HttpHandlerAdvice.class);
    private static final ElasticApmTracer tracer = GlobalTracer.requireTracerImpl();
    private static final HttpServerHelper serverHelper = new HttpServerHelper(tracer.getConfig(WebConfiguration.class));
    private static final WebConfiguration webConfiguration = tracer.getConfig(WebConfiguration.class);
    private static final CoreConfiguration coreConfiguration = tracer.getConfig(CoreConfiguration.class);

    @Nullable
    @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
    public static Object onEnterHandle(@Advice.Argument(value=0) HttpExchange exchange) {
        Headers headers;
        if (tracer.currentTransaction() != null || serverHelper.isRequestExcluded(exchange.getRequestURI().getPath(), exchange.getRequestHeaders().getFirst("User-Agent"))) {
            return null;
        }
        Transaction transaction = tracer.startChildTransaction(exchange.getRequestHeaders(), HeadersHeaderGetter.INSTANCE, Thread.currentThread().getContextClassLoader());
        if (transaction == null) {
            return null;
        }
        TransactionNameUtils.setNameFromHttpRequestPath(exchange.getRequestMethod(), exchange.getRequestURI().getPath(), transaction.getAndOverrideName(10), webConfiguration.getUrlGroups());
        ((Transaction)transaction.withType("request")).setFrameworkName("JDK HTTP Server");
        Request request = transaction.getContext().getRequest();
        request.getSocket().withRemoteAddress(exchange.getRemoteAddress().getAddress().getHostAddress());
        request.withHttpVersion(exchange.getProtocol()).withMethod(exchange.getRequestMethod());
        request.getUrl().withProtocol(exchange instanceof HttpsExchange ? "https" : "http").withHostname(HttpHandlerAdvice.getHostname(exchange)).withPort(exchange.getLocalAddress().getPort()).withPathname(exchange.getRequestURI().getPath()).withSearch(exchange.getRequestURI().getQuery());
        if (transaction.isSampled() && coreConfiguration.isCaptureHeaders() && (headers = exchange.getRequestHeaders()) != null) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                if ("Cookie".equalsIgnoreCase(header.getKey())) {
                    for (String[] cookie : CookieHelper.getCookies(header.getValue())) {
                        request.addCookie(cookie[0], cookie[1]);
                    }
                    continue;
                }
                request.addHeader(header.getKey(), Collections.enumeration((Collection)header.getValue()));
            }
        }
        return transaction.activate();
    }

    private static String getHostname(HttpExchange exchange) {
        Object hostHeader = exchange.getRequestHeaders().get("Host");
        if (hostHeader != null) {
            String port;
            String hostname = (String)hostHeader.get(0);
            int idx = hostname.lastIndexOf(58);
            if (idx > 0 && idx + 1 + (port = String.valueOf(exchange.getLocalAddress().getPort())).length() == hostname.length() && hostname.endsWith(port)) {
                hostname = hostname.substring(0, idx);
            }
            return hostname;
        }
        return exchange.getLocalAddress().getAddress().getHostName();
    }

    @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
    public static void onExitHandle(@Advice.Argument(value=0) HttpExchange exchange, @Advice.Enter @Nullable Object transactionOrNull, @Advice.Thrown @Nullable Throwable t) {
        Headers headers;
        if (transactionOrNull == null) {
            return;
        }
        Transaction transaction = (Transaction)transactionOrNull;
        transaction.withResultIfUnset(ResultUtil.getResultByHttpStatus(exchange.getResponseCode())).captureException(t);
        Response response = transaction.getContext().getResponse();
        response.withFinished(true).withStatusCode(exchange.getResponseCode());
        ElasticApmTracer tracer = GlobalTracer.getTracerImpl();
        if (transaction.isSampled() && tracer.getConfig(CoreConfiguration.class).isCaptureHeaders() && (headers = exchange.getResponseHeaders()) != null) {
            for (Map.Entry<String, List<String>> header : headers.entrySet()) {
                response.addHeader(header.getKey(), (Collection<String>)header.getValue());
            }
        }
        ((Transaction)transaction.deactivate()).end();
    }
}

