/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.httpclient.BaseApacheHttpClientInstrumentation;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.httpclient.helper.RequestHeaderAccessor;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.NamedElement;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.methods.HttpUriRequest;

public class LegacyApacheHttpClientInstrumentation
extends BaseApacheHttpClientInstrumentation {
    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.httpclient.LegacyApacheHttpClientInstrumentation$LegacyApacheHttpClientAdvice";
    }

    @Override
    public ElementMatcher<? super NamedElement> getTypeMatcherPreFilter() {
        return ElementMatchers.nameContains("Director");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.client.RequestDirector"));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(3)).and(ElementMatchers.returns(ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.HttpResponse")))).and(ElementMatchers.takesArgument(0, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.HttpHost")))).and(ElementMatchers.takesArgument(1, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.HttpRequest")))).and(ElementMatchers.takesArgument(2, ElementMatchers.hasSuperType(ElementMatchers.named("org.apache.http.protocol.HttpContext"))));
    }

    public static class LegacyApacheHttpClientAdvice {
        @Nullable
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static Object onBeforeExecute(@Advice.Argument(value=0) @Nullable HttpHost host, @Advice.Argument(value=1) HttpRequest request) {
            AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
            if (parent == null) {
                return null;
            }
            if (!(request instanceof HttpUriRequest)) {
                return null;
            }
            HttpUriRequest uriRequest = (HttpUriRequest)request;
            String hostName = host != null ? host.getHostName() : null;
            Span span = HttpClientHelper.startHttpClientSpan(parent, uriRequest.getMethod(), uriRequest.getURI(), hostName);
            if (span != null) {
                span.activate();
            }
            if (!TraceContext.containsTraceContextTextHeaders(request, RequestHeaderAccessor.INSTANCE)) {
                if (span != null) {
                    span.propagateTraceContext(request, RequestHeaderAccessor.INSTANCE);
                } else if (!TraceContext.containsTraceContextTextHeaders(request, RequestHeaderAccessor.INSTANCE)) {
                    parent.propagateTraceContext(request, RequestHeaderAccessor.INSTANCE);
                }
            }
            return span;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
        public static void onAfterExecute(@Advice.Return @Nullable HttpResponse response, @Advice.Enter @Nullable Object spanObj, @Advice.Thrown @Nullable Throwable t) {
            Span span = (Span)spanObj;
            if (span == null) {
                return;
            }
            try {
                if (response != null && response.getStatusLine() != null) {
                    int statusCode = response.getStatusLine().getStatusCode();
                    span.getContext().getHttp().withStatusCode(statusCode);
                }
                span.captureException(t);
            }
            finally {
                if (t instanceof CircularRedirectException) {
                    span.withOutcome(Outcome.FAILURE);
                }
                ((Span)span.deactivate()).end();
            }
        }
    }
}

