/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.httpclient;

import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.net.URI;
import javax.annotation.Nullable;

public class HttpClientHelper {
    private static final Logger logger = LoggerFactory.getLogger(HttpClientHelper.class);
    public static final String EXTERNAL_TYPE = "external";
    public static final String HTTP_SUBTYPE = "http";

    @Nullable
    public static Span startHttpClientSpan(AbstractSpan<?> parent, String method, @Nullable URI uri, @Nullable CharSequence hostName) {
        String uriString = null;
        String scheme = null;
        int port = -1;
        if (uri != null) {
            uriString = uri.toString();
            scheme = uri.getScheme();
            port = uri.getPort();
            if (hostName == null) {
                hostName = uri.getHost();
            }
        }
        return HttpClientHelper.startHttpClientSpan(parent, method, uriString, scheme, hostName, port);
    }

    @Nullable
    public static Span startHttpClientSpan(AbstractSpan<?> parent, String method, @Nullable String uri, String scheme, CharSequence hostName, int port) {
        Span span = parent.createExitSpan();
        if (span != null) {
            ((Span)((Span)((Span)span.withType(EXTERNAL_TYPE)).withSubtype(HTTP_SUBTYPE).appendToName(method)).appendToName(" ")).appendToName(hostName);
            span.getContext().getHttp().withUrl(uri).withMethod(method);
            HttpClientHelper.setDestinationServiceDetails(span, scheme, hostName, port);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("Created an HTTP exit span: {} for URI: {}. Parent span: {}", span, uri, parent);
        }
        return span;
    }

    public static void setDestinationServiceDetails(Span span, @Nullable String scheme, @Nullable CharSequence host, int port) {
        if (scheme == null || host == null || host.length() == 0) {
            return;
        }
        if (HTTP_SUBTYPE.equals(scheme)) {
            if (port < 0) {
                port = 80;
            }
        } else if ("https".equals(scheme)) {
            if (port < 0) {
                port = 443;
            }
        } else {
            return;
        }
        span.getContext().getDestination().withAddress(host).withPort(port);
        span.getContext().getServiceTarget().withType(HTTP_SUBTYPE).withHostPortName(host, port).withNameOnlyDestinationResource();
    }
}

