/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.grpc;

import co.elastic.apm.agent.grpc.BaseInstrumentation;
import co.elastic.apm.agent.grpc.GrpcHelper;
import io.grpc.ClientCall;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class DelayedClientCallInstrumentation
extends BaseInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.grpc.internal.DelayedClientCall");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("setRealCall").and(ElementMatchers.takesArgument(0, ElementMatchers.named("io.grpc.ClientCall")));
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.grpc.DelayedClientCallInstrumentation$DelayedClientCallAdvice";
    }

    public static class DelayedClientCallAdvice {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        public static void onEnter(@Advice.This ClientCall<?, ?> placeholderClientCall, @Advice.Argument(value=0) ClientCall<?, ?> realClientCall) {
            GrpcHelper.getInstance().replaceClientCallRegistration(placeholderClientCall, realClientCall);
        }
    }
}

