/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.esrestclient;

import co.elastic.apm.agent.esrestclient.ResponseListenerWrapper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.objectpool.Allocator;
import co.elastic.apm.agent.objectpool.ObjectPool;
import co.elastic.apm.agent.objectpool.impl.QueueBasedObjectPool;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.IOUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CancellationException;
import javax.annotation.Nullable;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.elasticsearch.client.Response;
import org.elasticsearch.client.ResponseException;
import org.elasticsearch.client.ResponseListener;
import org.jctools.queues.atomic.AtomicQueueFactory;
import org.jctools.queues.spec.ConcurrentQueueSpec;

public class ElasticsearchRestClientInstrumentationHelper {
    private static final Logger logger = LoggerFactory.getLogger(ElasticsearchRestClientInstrumentationHelper.class);
    private static final ElasticsearchRestClientInstrumentationHelper INSTANCE = new ElasticsearchRestClientInstrumentationHelper(GlobalTracer.requireTracerImpl());
    public static final List<WildcardMatcher> QUERY_WILDCARD_MATCHERS = Arrays.asList(WildcardMatcher.valueOf("*_search"), WildcardMatcher.valueOf("*_msearch"), WildcardMatcher.valueOf("*_msearch/template"), WildcardMatcher.valueOf("*_search/template"), WildcardMatcher.valueOf("*_count"));
    public static final String SPAN_TYPE = "db";
    public static final String ELASTICSEARCH = "elasticsearch";
    public static final String SPAN_ACTION = "request";
    private static final int MAX_POOLED_ELEMENTS = 256;
    private final ElasticApmTracer tracer;
    private final ObjectPool<ResponseListenerWrapper> responseListenerObjectPool;

    public static ElasticsearchRestClientInstrumentationHelper get() {
        return INSTANCE;
    }

    private ElasticsearchRestClientInstrumentationHelper(ElasticApmTracer tracer) {
        this.tracer = tracer;
        this.responseListenerObjectPool = QueueBasedObjectPool.ofRecyclable(AtomicQueueFactory.newQueue(ConcurrentQueueSpec.createBoundedMpmc(256)), false, new ResponseListenerAllocator());
    }

    @Nullable
    public Span createClientSpan(String method, String endpoint, @Nullable HttpEntity httpEntity) {
        AbstractSpan<?> activeSpan = this.tracer.getActive();
        if (activeSpan == null) {
            return null;
        }
        Span span = activeSpan.createExitSpan();
        if (span == null) {
            return null;
        }
        ((Span)((Span)((Span)((Span)span.withType(SPAN_TYPE)).withSubtype(ELASTICSEARCH).withAction(SPAN_ACTION).appendToName("Elasticsearch: ")).appendToName(method)).appendToName(" ")).appendToName(endpoint);
        span.getContext().getDb().withType(ELASTICSEARCH);
        span.activate();
        if (span.isSampled()) {
            span.getContext().getHttp().withMethod(method);
            if (WildcardMatcher.isAnyMatch(QUERY_WILDCARD_MATCHERS, endpoint) && httpEntity != null && httpEntity.isRepeatable()) {
                try {
                    IOUtils.readUtf8Stream(httpEntity.getContent(), span.getContext().getDb().withStatementBuffer());
                }
                catch (IOException e) {
                    logger.error("Failed to read Elasticsearch client query from request body", e);
                }
            }
            span.getContext().getServiceTarget().withType(ELASTICSEARCH);
        }
        return span;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finishClientSpan(@Nullable Response response, Span span, @Nullable Throwable t) {
        try {
            String url = null;
            int statusCode = -1;
            String address = null;
            int port = -1;
            if (response != null) {
                HttpHost host = response.getHost();
                address = host.getHostName();
                port = host.getPort();
                url = host.toURI();
                statusCode = response.getStatusLine().getStatusCode();
            } else if (t != null) {
                if (t instanceof ResponseException) {
                    ResponseException esre = (ResponseException)t;
                    HttpHost host = esre.getResponse().getHost();
                    address = host.getHostName();
                    port = host.getPort();
                    url = host.toURI();
                    statusCode = esre.getResponse().getStatusLine().getStatusCode();
                } else if (t instanceof CancellationException) {
                    span.withOutcome(Outcome.UNKNOWN);
                }
                span.captureException(t);
            }
            if (url != null && !url.isEmpty()) {
                span.getContext().getHttp().withUrl(url);
            }
            span.getContext().getHttp().withStatusCode(statusCode);
            span.getContext().getDestination().withAddress(address).withPort(port);
        }
        finally {
            span.end();
        }
    }

    public ResponseListener wrapResponseListener(ResponseListener listener, Span span) {
        return this.responseListenerObjectPool.createInstance().with(listener, span);
    }

    void recycle(ResponseListenerWrapper listenerWrapper) {
        this.responseListenerObjectPool.recycle(listenerWrapper);
    }

    private class ResponseListenerAllocator
    implements Allocator<ResponseListenerWrapper> {
        private ResponseListenerAllocator() {
        }

        @Override
        public ResponseListenerWrapper createInstance() {
            return new ResponseListenerWrapper(ElasticsearchRestClientInstrumentationHelper.this);
        }
    }
}

