/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration.source;

import co.elastic.apm.agent.configuration.source.PropertyFileConfigurationSource;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import javax.annotation.Nullable;
import org.stagemonitor.configuration.source.SimpleSource;

public class ConfigSources {
    private ConfigSources() {
    }

    @Nullable
    public static SimpleSource fromRuntimeAttachParameters(String location) {
        return ConfigSources.buildSimpleSource("Attachment configuration", ConfigSources.getPropertiesFromFilesystem(location));
    }

    @Nullable
    public static SimpleSource fromClasspath(String location, ClassLoader classLoader) {
        return ConfigSources.buildSimpleSource("classpath:" + location, ConfigSources.getPropertiesFromClasspath(location, classLoader));
    }

    @Nullable
    public static PropertyFileConfigurationSource fromFileSystem(@Nullable String location) {
        Properties properties = ConfigSources.getPropertiesFromFilesystem(location);
        if (properties == null) {
            return null;
        }
        return new PropertyFileConfigurationSource(location, properties);
    }

    private static SimpleSource buildSimpleSource(String name, Properties properties) {
        if (properties == null) {
            return null;
        }
        SimpleSource source = new SimpleSource(name);
        for (String key : properties.stringPropertyNames()) {
            source.add(key, properties.getProperty(key));
        }
        return source;
    }

    static Properties getPropertiesFromFilesystem(String location) {
        Properties properties;
        if (location == null) {
            return null;
        }
        Properties props = new Properties();
        FileInputStream input = new FileInputStream(location);
        try {
            props.load(input);
            properties = props;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)input).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (FileNotFoundException ex) {
                return null;
            }
            catch (IOException e) {
                e.printStackTrace();
                return null;
            }
        }
        ((InputStream)input).close();
        return properties;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Properties getPropertiesFromClasspath(String classpathLocation, ClassLoader classLoader) {
        Properties props = new Properties();
        try (InputStream resourceStream = classLoader.getResourceAsStream(classpathLocation);){
            if (resourceStream == null) return null;
            props.load(resourceStream);
            Properties properties = props;
            return properties;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

