/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import co.elastic.apm.agent.configuration.CoreConfiguration;
import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.stacktrace.StacktraceConfiguration;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import co.elastic.apm.agent.util.VersionUtils;
import java.lang.management.ManagementFactory;
import java.util.List;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationRegistry;

public class StartupInfo
extends AbstractLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(StartupInfo.class);
    private final String elasticApmVersion = VersionUtils.getAgentVersion();

    private static String getJvmAndOsVersionString() {
        return "Java " + System.getProperty("java.version") + " Runtime version: " + System.getProperty("java.runtime.version") + " VM version: " + System.getProperty("java.vm.version") + " (" + System.getProperty("java.vendor") + ") " + System.getProperty("os.name") + " " + System.getProperty("os.version");
    }

    @Override
    public void init(ElasticApmTracer tracer) {
        ConfigurationRegistry configurationRegistry = tracer.getConfigurationRegistry();
        this.logConfiguration(configurationRegistry, logger);
    }

    void logConfiguration(ConfigurationRegistry configurationRegistry, Logger logger) {
        String serviceName = configurationRegistry.getConfig(CoreConfiguration.class).getServiceName();
        String serviceVersion = configurationRegistry.getConfig(CoreConfiguration.class).getServiceVersion();
        StringBuilder serviceNameAndVersion = new StringBuilder(serviceName);
        if (serviceVersion != null) {
            serviceNameAndVersion.append(" (").append(serviceVersion).append(")");
        }
        logger.info("Starting Elastic APM {} as {} on {}", this.elasticApmVersion, serviceNameAndVersion, StartupInfo.getJvmAndOsVersionString());
        logger.debug("VM Arguments: {}", (Object)ManagementFactory.getRuntimeMXBean().getInputArguments());
        for (List<ConfigurationOption<?>> options : configurationRegistry.getConfigurationOptionsByCategory().values()) {
            for (ConfigurationOption<?> option : options) {
                if (option.isDefault()) continue;
                this.logConfigWithNonDefaultValue(logger, option);
            }
        }
        if (configurationRegistry.getConfig(StacktraceConfiguration.class).getApplicationPackages().isEmpty()) {
            logger.warn("To enable all features and decrease startup time, please configure {}", (Object)"application_packages");
        }
    }

    private void logConfigWithNonDefaultValue(Logger logger, ConfigurationOption<?> option) {
        logger.info("{}: '{}' (source: {})", option.getKey(), option.isSensitive() ? "XXXX" : option.getValueAsSafeString(), option.getNameOfCurrentConfigurationSource());
        if (option.getTags().contains("deprecated")) {
            logger.warn("Detected usage of deprecated configuration option '{}'. This option might be removed in the future. Please refer to the documentation about alternatives.", (Object)option.getKey());
        }
        if (!option.getKey().equals(option.getUsedKey())) {
            logger.warn("Detected usage of an old configuration key: '{}'. Please use '{}' instead.", (Object)option.getUsedKey(), (Object)option.getKey());
        }
        if (option.getValue() instanceof TimeDuration && !TimeDuration.DURATION_PATTERN.matcher(option.getValueAsString()).matches()) {
            logger.warn("DEPRECATION WARNING: {}: '{}' (source: {}) is not using a time unit. Please use one of 'ms', 's' or 'm'.", option.getKey(), option.getValueAsString(), option.getNameOfCurrentConfigurationSource());
        }
    }
}

