/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.configuration.converter.TimeDurationValueConverter;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;

public class SpanConfiguration
extends ConfigurationOptionProvider {
    public static final String HUGE_TRACES_CATEGORY = "Huge Traces";
    private final ConfigurationOption<Boolean> spanCompressionEnabled = ConfigurationOption.booleanOption().key("span_compression_enabled").configurationCategory("Huge Traces").tags("added[1.30.0]").description("Setting this option to true will enable span compression feature.\nSpan compression reduces the collection, processing, and storage overhead, and removes clutter from the UI. The tradeoff is that some information such as DB statements of all the compressed spans will not be collected.").dynamic(true).buildWithDefault(true);
    private final ConfigurationOption<TimeDuration> spanCompressionExactMatchMaxDuration = TimeDurationValueConverter.durationOption("ms").key("span_compression_exact_match_max_duration").configurationCategory("Huge Traces").tags("added[1.30.0]").description("Consecutive spans that are exact match and that are under this threshold will be compressed into a single composite span. This option does not apply to composite spans. This reduces the collection, processing, and storage overhead, and removes clutter from the UI. The tradeoff is that the DB statements of all the compressed spans will not be collected.").dynamic(true).buildWithDefault(TimeDuration.of("50ms"));
    private final ConfigurationOption<TimeDuration> spanCompressionSameKindMaxDuration = TimeDurationValueConverter.durationOption("ms").key("span_compression_same_kind_max_duration").configurationCategory("Huge Traces").tags("added[1.30.0]").description("Consecutive spans to the same destination that are under this threshold will be compressed into a single composite span. This option does not apply to composite spans. This reduces the collection, processing, and storage overhead, and removes clutter from the UI. The tradeoff is that the DB statements of all the compressed spans will not be collected.").dynamic(true).buildWithDefault(TimeDuration.of("0ms"));
    private final ConfigurationOption<TimeDuration> exitSpanMinDuration = TimeDurationValueConverter.fineDurationOption().key("exit_span_min_duration").tags("added[1.30.0]").configurationCategory("Huge Traces").description("Exit spans are spans that represent a call to an external service, like a database. If such calls are very short, they are usually not relevant and can be ignored.\n\nNOTE: If a span propagates distributed tracing ids, it will not be ignored, even if it is shorter than the configured threshold. This is to ensure that no broken traces are recorded.").dynamic(true).buildWithDefault(TimeDuration.ofFine("0ms"));

    public boolean isSpanCompressionEnabled() {
        return this.spanCompressionEnabled.get();
    }

    public TimeDuration getSpanCompressionExactMatchMaxDuration() {
        return this.spanCompressionExactMatchMaxDuration.get();
    }

    public TimeDuration getSpanCompressionSameKindMaxDuration() {
        return this.spanCompressionSameKindMaxDuration.get();
    }

    public TimeDuration getExitSpanMinDuration() {
        return this.exitSpanMinDuration.get();
    }
}

