/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import java.util.Objects;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.annotation.Nullable;

public class ServiceInfo {
    private static final String JAR_VERSION_SUFFIX = "-(\\d+\\.)+(\\d+)(.*)?$";
    private static final String DEFAULT_SERVICE_NAME = "unknown-java-service";
    private static final ServiceInfo EMPTY = new ServiceInfo(null, null);
    private static final ServiceInfo AUTO_DETECTED = ServiceInfo.autoDetect(System.getProperties());
    private final String serviceName;
    @Nullable
    private final String serviceVersion;
    private final boolean multiServiceContainer;

    public ServiceInfo(@Nullable String serviceName) {
        this(serviceName, null);
    }

    private ServiceInfo(@Nullable String serviceName, @Nullable String serviceVersion) {
        this(serviceName, serviceVersion, false);
    }

    private ServiceInfo(@Nullable String serviceName, @Nullable String serviceVersion, boolean multiServiceContainer) {
        this.multiServiceContainer = multiServiceContainer;
        this.serviceName = serviceName == null || serviceName.trim().isEmpty() ? DEFAULT_SERVICE_NAME : ServiceInfo.replaceDisallowedServiceNameChars(serviceName).trim();
        this.serviceVersion = serviceVersion;
    }

    public static ServiceInfo empty() {
        return EMPTY;
    }

    public static ServiceInfo of(@Nullable String serviceName) {
        return ServiceInfo.of(serviceName, null);
    }

    public static ServiceInfo ofMultiServiceContainer(String serviceName) {
        return new ServiceInfo(serviceName, null, true);
    }

    public static ServiceInfo of(@Nullable String serviceName, @Nullable String serviceVersion) {
        if ((serviceName == null || serviceName.isEmpty()) && (serviceVersion == null || serviceVersion.isEmpty())) {
            return ServiceInfo.empty();
        }
        return new ServiceInfo(serviceName, serviceVersion);
    }

    private static String replaceDisallowedServiceNameChars(String serviceName) {
        return serviceName.replaceAll("[^a-zA-Z0-9 _-]", "-");
    }

    public static ServiceInfo autoDetected() {
        return AUTO_DETECTED;
    }

    public static ServiceInfo autoDetect(Properties properties) {
        String lambdaFunctionName = System.getenv("AWS_LAMBDA_FUNCTION_NAME");
        if (lambdaFunctionName != null) {
            return new ServiceInfo(lambdaFunctionName, System.getenv("AWS_LAMBDA_FUNCTION_VERSION"));
        }
        ServiceInfo serviceInfo = ServiceInfo.createFromSunJavaCommand(properties.getProperty("sun.java.command"));
        if (serviceInfo != null) {
            return serviceInfo;
        }
        return ServiceInfo.empty();
    }

    @Nullable
    private static ServiceInfo createFromSunJavaCommand(@Nullable String command) {
        if (command == null) {
            return null;
        }
        String serviceName = ServiceInfo.getContainerServiceName(command = command.trim());
        if (serviceName != null) {
            return ServiceInfo.ofMultiServiceContainer(serviceName);
        }
        if (command.contains(".jar")) {
            return ServiceInfo.fromJarCommand(command);
        }
        return ServiceInfo.fromMainClassCommand(command);
    }

    @Nullable
    private static String getContainerServiceName(String command) {
        if (command.startsWith("org.apache.catalina.startup.Bootstrap")) {
            return "tomcat-application";
        }
        if (command.startsWith("org.eclipse.jetty")) {
            return "jetty-application";
        }
        if (command.startsWith("com.sun.enterprise.glassfish")) {
            return "glassfish-application";
        }
        if (command.contains("ws-server.jar")) {
            return "websphere-application";
        }
        if (command.contains("jboss-modules.jar")) {
            return "jboss-application";
        }
        if (command.contains("weblogic")) {
            return "weblogic-application";
        }
        return null;
    }

    private static ServiceInfo fromJarCommand(String command) {
        String[] commandParts = command.split(" ");
        ServiceInfo serviceInfoFromManifest = ServiceInfo.empty();
        ServiceInfo serviceInfoFromJarName = ServiceInfo.empty();
        for (String commandPart : commandParts) {
            if (!commandPart.endsWith(".jar")) continue;
            try (JarFile jarFile = new JarFile(commandPart);){
                serviceInfoFromManifest = ServiceInfo.fromManifest(jarFile.getManifest());
            }
            catch (Exception exception) {
                // empty catch block
            }
            serviceInfoFromJarName = ServiceInfo.of(ServiceInfo.removeVersionFromJar(ServiceInfo.removePath(ServiceInfo.removeJarExtension(commandPart))));
            break;
        }
        return serviceInfoFromManifest.withFallback(serviceInfoFromJarName);
    }

    public static ServiceInfo fromManifest(@Nullable Manifest manifest) {
        if (manifest == null) {
            return ServiceInfo.empty();
        }
        Attributes mainAttributes = manifest.getMainAttributes();
        return ServiceInfo.of(mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_TITLE), mainAttributes.getValue(Attributes.Name.IMPLEMENTATION_VERSION));
    }

    private static String removeJarExtension(String commandPart) {
        return commandPart.substring(0, commandPart.indexOf(".jar"));
    }

    private static String removePath(String path) {
        return path.substring(path.lastIndexOf("/") + 1).substring(path.lastIndexOf("\\") + 1);
    }

    private static String removeVersionFromJar(String jarFileName) {
        return jarFileName.replaceFirst(JAR_VERSION_SUFFIX, "");
    }

    private static ServiceInfo fromMainClassCommand(String command) {
        int indexOfSpace = command.indexOf(32);
        String mainClassName = indexOfSpace != -1 ? command.substring(0, indexOfSpace) : command;
        return new ServiceInfo(mainClassName.substring(mainClassName.lastIndexOf(46) + 1));
    }

    public String getServiceName() {
        return this.serviceName;
    }

    @Nullable
    public String getServiceVersion() {
        return this.serviceVersion;
    }

    public boolean isMultiServiceContainer() {
        return this.multiServiceContainer;
    }

    public ServiceInfo withFallback(ServiceInfo fallback) {
        return ServiceInfo.of(this.hasServiceName() ? this.serviceName : fallback.serviceName, this.serviceVersion != null ? this.serviceVersion : fallback.serviceVersion);
    }

    public boolean hasServiceName() {
        return !this.serviceName.equals(DEFAULT_SERVICE_NAME);
    }

    public boolean isEmpty() {
        return !this.hasServiceName() && this.serviceVersion == null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceInfo that = (ServiceInfo)o;
        return this.multiServiceContainer == that.multiServiceContainer && this.serviceName.equals(that.serviceName) && Objects.equals(this.serviceVersion, that.serviceVersion);
    }

    public int hashCode() {
        return Objects.hash(this.serviceName, this.serviceVersion, this.multiServiceContainer);
    }

    public String toString() {
        return "ServiceInfo{serviceName='" + this.serviceName + '\'' + ", serviceVersion='" + this.serviceVersion + '\'' + ", multiServiceContainer=" + this.multiServiceContainer + '}';
    }
}

