/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.configuration;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.configuration.ServiceInfo;
import co.elastic.apm.agent.configuration.converter.ListValueConverter;
import co.elastic.apm.agent.configuration.converter.RoundedDoubleConverter;
import co.elastic.apm.agent.configuration.converter.TimeDuration;
import co.elastic.apm.agent.configuration.converter.TimeDurationValueConverter;
import co.elastic.apm.agent.configuration.validation.RangeValidator;
import co.elastic.apm.agent.configuration.validation.RegexValidator;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.matcher.MethodMatcher;
import co.elastic.apm.agent.matcher.MethodMatcherValueConverter;
import co.elastic.apm.agent.matcher.WildcardMatcher;
import co.elastic.apm.agent.matcher.WildcardMatcherValueConverter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.stagemonitor.configuration.ConfigurationOption;
import org.stagemonitor.configuration.ConfigurationOptionProvider;
import org.stagemonitor.configuration.converter.AbstractValueConverter;
import org.stagemonitor.configuration.converter.MapValueConverter;
import org.stagemonitor.configuration.converter.SetValueConverter;
import org.stagemonitor.configuration.converter.StringValueConverter;
import org.stagemonitor.configuration.source.ConfigurationSource;

public class CoreConfiguration
extends ConfigurationOptionProvider {
    public static final String INSTRUMENT = "instrument";
    public static final String SERVICE_NAME = "service_name";
    public static final String SERVICE_NODE_NAME = "service_node_name";
    public static final String SAMPLE_RATE = "transaction_sample_rate";
    public static final String CORE_CATEGORY = "Core";
    private static final String DEFAULT_CONFIG_FILE = "_AGENT_HOME_/elasticapm.properties";
    public static final String CONFIG_FILE = "config_file";
    public static final String ENABLED_KEY = "enabled";
    private final ConfigurationOption<Boolean> enabled = ConfigurationOption.booleanOption().key("enabled").configurationCategory("Core").description("Setting to false will completely disable the agent, including instrumentation and remote config polling.\nIf you want to dynamically change the status of the agent, use <<config-recording,`recording`>> instead.").dynamic(false).tags("added[1.18.0]").buildWithDefault(true);
    private final ConfigurationOption<Boolean> instrument = ConfigurationOption.booleanOption().key("instrument").configurationCategory("Core").description("A boolean specifying if the agent should instrument the application to collect traces for the app.\n When set to `false`, most built-in instrumentation plugins are disabled, which would minimize the effect on \nyour application. However, the agent would still apply instrumentation related to manual tracing options and it \nwould still collect and send metrics to APM Server.\n\nNOTE: Both active and instrument needs to be true for instrumentation to be running.\n\nNOTE: Changing this value at runtime can slow down the application temporarily.").dynamic(true).tags("added[1.0.0,Changing this value at runtime is possible since version 1.15.0]").buildWithDefault(true);
    private final ConfigurationOption<String> serviceName = ConfigurationOption.stringOption().key("service_name").configurationCategory("Core").label("The name of your service").description("This is used to keep all the errors and transactions of your service together\nand is the primary filter in the Elastic APM user interface.\n\nInstead of configuring the service name manually,\nyou can also choose to rely on the service name auto-detection mechanisms of the agent.\nIf `service_name` is set explicitly, all auto-detection mechanisms are disabled.\n\nThis is how the service name auto-detection works:\n\n* For standalone applications\n** The agent uses `Implementation-Title` in the `META-INF/MANIFEST.MF` file if the application is started via `java -jar`.\n** Falls back to the name of the main class or jar file.\n* For applications that are deployed to a servlet container/application server, the agent auto-detects the name for each application.\n** For Spring-based applications, the agent uses the `spring.application.name` property, if set.\n** For servlet-based applications, falls back to the `Implementation-Title` in the `META-INF/MANIFEST.MF` file.\n** Falls back to the `display-name` of the `web.xml`, if available.\n** Falls back to the servlet context path the application is mapped to (unless mapped to the root context).\n\nGenerally, it is recommended to rely on the service name detection based on `META-INF/MANIFEST.MF`.\nSpring Boot automatically adds the relevant manifest entries.\nFor other applications that are built with Maven, this is how you add the manifest entries:\n\n<#noparse>\n[source,xml]\n.pom.xml\n----\n    <build>\n        <plugins>\n            <plugin>\n                <!-- replace with 'maven-war-plugin' if you're building a war -->\n                <artifactId>maven-jar-plugin</artifactId>\n                <configuration>\n                    <archive>\n                        <!-- Adds\n                        Implementation-Title based on ${project.name} and\n                        Implementation-Version based on ${project.version}\n                        -->\n                        <manifest>\n                            <addDefaultImplementationEntries>true</addDefaultImplementationEntries>\n                        </manifest>\n                        <!-- To customize the Implementation-* entries, remove addDefaultImplementationEntries and add them manually\n                        <manifestEntries>\n                            <Implementation-Title>foo</Implementation-Title>\n                            <Implementation-Version>4.2.0</Implementation-Version>\n                        </manifestEntries>\n                        -->\n                    </archive>\n                </configuration>\n            </plugin>\n        </plugins>\n    </build>\n----\n</#noparse>\n\nThe service name must conform to this regular expression: `^[a-zA-Z0-9 _-]+$`.\nIn less regexy terms:\nYour service name must only contain characters from the ASCII alphabet, numbers, dashes, underscores and spaces.\n\nNOTE: Service name auto discovery mechanisms require APM Server 7.0+.").addValidator(RegexValidator.of("^[a-zA-Z0-9 _-]+$", "Your service name \"{0}\" must only contain characters from the ASCII alphabet, numbers, dashes, underscores and spaces")).buildWithDefault(ServiceInfo.autoDetected().getServiceName());
    private final ConfigurationOption<String> serviceNodeName = ConfigurationOption.stringOption().key("service_node_name").configurationCategory("Core").label("A unique name for the service node").description("If set, this name is used to distinguish between different nodes of a service, \ntherefore it should be unique for each JVM within a service. \nIf not set, data aggregations will be done based on a container ID (where valid) or on the reported \nhostname (automatically discovered or manually configured through <<config-hostname, `hostname`>>). \n\nNOTE: JVM metrics views rely on aggregations that are based on the service node name. \nIf you have multiple JVMs installed on the same host reporting data for the same service name, \nyou must set a unique node name for each in order to view metrics at the JVM level.\n\nNOTE: Metrics views can utilize this configuration since APM Server 7.5").tags("added[1.11.0]").build();
    private final ConfigurationOption<TimeDuration> delayTracerStart = TimeDurationValueConverter.durationOption("ms").key("delay_tracer_start").aliasKeys("delay_initialization").configurationCategory("Core").tags("internal").description("If set to a value greater than 0ms, the agent will delay tracer start. Instrumentation will not be delayed, as well as some tracer initialization processes, like LifecycleListeners initializations.").buildWithDefault(TimeDuration.of("0ms"));
    private final ConfigurationOption<String> serviceVersion = ConfigurationOption.stringOption().key("service_version").configurationCategory("Core").description("A version string for the currently deployed version of the service. If you don\u2019t version your deployments, the recommended value for this field is the commit identifier of the deployed revision, e.g. the output of git rev-parse HEAD.\n\nSimilar to the auto-detection of <<config-service-name>>, the agent can auto-detect the service version based on the `Implementation-Title` attribute in `META-INF/MANIFEST.MF`.\nSee <<config-service-name>> on how to set this attribute.\n\n").defaultValue(ServiceInfo.autoDetected().getServiceVersion()).build();
    private final ConfigurationOption<String> hostname = ConfigurationOption.stringOption().key("hostname").tags("added[1.10.0]").configurationCategory("Core").description("Allows for the reported hostname to be manually specified. If unset the hostname will be looked up.").build();
    private final ConfigurationOption<String> environment = ConfigurationOption.stringOption().key("environment").configurationCategory("Core").description("The name of the environment this service is deployed in, e.g. \"production\" or \"staging\".\n\nEnvironments allow you to easily filter data on a global level in the APM app.\nIt's important to be consistent when naming environments across agents.\nSee {apm-app-ref}/filters.html#environment-selector[environment selector] in the APM app for more information.\n\nNOTE: This feature is fully supported in the APM app in Kibana versions >= 7.2.\nYou must use the query bar to filter for a specific environment in versions prior to 7.2.").build();
    private final ConfigurationOption<Double> sampleRate = ConfigurationOption.builder(RoundedDoubleConverter.withDefaultPrecision(), Double.class).key("transaction_sample_rate").aliasKeys("sample_rate").configurationCategory("Core").tags("performance").description("By default, the agent will sample every transaction (e.g. request to your service). To reduce overhead and storage requirements, you can set the sample rate to a value between 0.0 and 1.0. We still record overall time and the result for unsampled transactions, but no context information, labels, or spans.\n\nValue will be rounded with 4 significant digits, as an example, value '0.55555' will be rounded to `0.5556`").dynamic(true).addValidator(RangeValidator.isInRange(0.0, 1.0)).buildWithDefault(1.0);
    private final ConfigurationOption<Integer> transactionMaxSpans = ConfigurationOption.integerOption().key("transaction_max_spans").configurationCategory("Core").tags("performance").description("Limits the amount of spans that are recorded per transaction.\n\nThis is helpful in cases where a transaction creates a very high amount of spans (e.g. thousands of SQL queries).\n\nSetting an upper limit will prevent overloading the agent and the APM server with too much work for such edge cases.\n\nA message will be logged when the max number of spans has been exceeded but only at a rate of once every " + TimeUnit.MICROSECONDS.toMinutes(Span.MAX_LOG_INTERVAL_MICRO_SECS) + " minutes to ensure performance is not impacted.").dynamic(true).buildWithDefault(500);
    private final ConfigurationOption<List<WildcardMatcher>> sanitizeFieldNames = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("sanitize_field_names").configurationCategory("Core").description("Sometimes it is necessary to sanitize the data sent to Elastic APM,\ne.g. remove sensitive data.\n\nConfigure a list of wildcard patterns of field names which should be sanitized.\nThese apply for example to HTTP headers and `application/x-www-form-urlencoded` data.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.\n\nNOTE: Data in the query string is considered non-sensitive,\nas sensitive information should not be sent in the query string.\nSee https://www.owasp.org/index.php/Information_exposure_through_query_strings_in_url for more information\n\nNOTE: Review the data captured by Elastic APM carefully to make sure it does not capture sensitive information.\nIf you do find sensitive data in the Elasticsearch index,\nyou should add an additional entry to this list (make sure to also include the default entries).").dynamic(true).tags("security").buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("password"), WildcardMatcher.valueOf("passwd"), WildcardMatcher.valueOf("pwd"), WildcardMatcher.valueOf("secret"), WildcardMatcher.valueOf("*key"), WildcardMatcher.valueOf("*token*"), WildcardMatcher.valueOf("*session*"), WildcardMatcher.valueOf("*credit*"), WildcardMatcher.valueOf("*card*"), WildcardMatcher.valueOf("*auth*"), WildcardMatcher.valueOf("set-cookie")));
    private final ConfigurationOption<Collection<String>> enabledInstrumentations = ConfigurationOption.stringsOption().key("enable_instrumentations").configurationCategory("Core").description("A list of instrumentations which should be selectively enabled.\nValid options are ${allInstrumentationGroupNames}.\nWhen set to non-empty value, only listed instrumentations will be enabled if they are not disabled through <<config-disable-instrumentations>> or <<config-enable-experimental-instrumentations>>.\nWhen not set or empty (default), all instrumentations enabled by default will be enabled unless they are disabled through <<config-disable-instrumentations>> or <<config-enable-experimental-instrumentations>>.\n\nNOTE: Changing this value at runtime can slow down the application temporarily.").dynamic(true).tags("added[1.28.0]").buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<Collection<String>> disabledInstrumentations = ConfigurationOption.builder(new AbstractValueConverter<Collection<String>>(){

        @Override
        public Collection<String> convert(String s) {
            Object values = SetValueConverter.STRINGS_VALUE_CONVERTER.convert(s);
            if (values.contains("incubating")) {
                LinkedHashSet<String> legacyValues = new LinkedHashSet<String>((Collection<String>)values);
                legacyValues.add("experimental");
                return Collections.unmodifiableSet(legacyValues);
            }
            return values;
        }

        @Override
        public String toString(Collection<String> value) {
            return SetValueConverter.STRINGS_VALUE_CONVERTER.toString(value);
        }
    }, Collection.class).key("disable_instrumentations").aliasKeys("disabled_instrumentations").configurationCategory("Core").description("A list of instrumentations which should be disabled.\nValid options are ${allInstrumentationGroupNames}.\nFor version `1.25.0` and later, use <<config-enable-experimental-instrumentations>> to enable experimental instrumentations.\n\nNOTE: Changing this value at runtime can slow down the application temporarily.").dynamic(true).tags("added[1.0.0,Changing this value at runtime is possible since version 1.15.0]").buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<Boolean> enableExperimentalInstrumentations = ConfigurationOption.booleanOption().key("enable_experimental_instrumentations").configurationCategory("Core").description("Whether to apply experimental instrumentations.\n\nNOTE: Changing this value at runtime can slow down the application temporarily.\nSetting to `true` will enable instrumentations in the `experimental` group.").dynamic(true).tags("added[1.25.0]").buildWithDefault(false);
    private final ConfigurationOption<List<WildcardMatcher>> unnestExceptions = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("unnest_exceptions").configurationCategory("Core").description("When reporting exceptions,\nun-nests the exceptions matching the wildcard pattern.\nThis can come in handy for Spring's `org.springframework.web.util.NestedServletException`,\nfor example.\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Collections.singletonList(WildcardMatcher.valueOf("(?-i)*Nested*Exception")));
    private final ConfigurationOption<List<WildcardMatcher>> ignoreExceptions = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("ignore_exceptions").tags("added[1.11.0]").configurationCategory("Core").description("A list of exceptions that should be ignored and not reported as errors.\nThis allows to ignore exceptions thrown in regular control flow that are not actual errors\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.\n\nExamples:\n\n - `com.mycompany.ExceptionToIgnore`: using fully qualified name\n - `*ExceptionToIgnore`: using wildcard to avoid package name\n - `*exceptiontoignore`: case-insensitive by default\n\nNOTE: Exception inheritance is not supported, thus you have to explicitly list all the thrown exception types").dynamic(true).buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<EventType> captureBody = ConfigurationOption.enumOption(EventType.class).key("capture_body").configurationCategory("Core").tags("performance").description("For transactions that are HTTP requests, the Java agent can optionally capture the request body (e.g. POST \nvariables). For transactions that are initiated by receiving a message from a message broker, the agent can \ncapture the textual message body.\n\nIf the HTTP request or the message has a body and this setting is disabled, the body will be shown as [REDACTED].\n\nThis option is case-insensitive.\n\nNOTE: Currently, the body length is limited to 10000 characters and it is not configurable. \nIf the body size exceeds the limit, it will be truncated. \n\nNOTE: Currently, only UTF-8 encoded plain text HTTP content types are supported.\nThe option <<config-capture-body-content-types>> determines which content types are captured.\n\nWARNING: Request bodies often contain sensitive values like passwords, credit card numbers etc.\nIf your service handles data like this, we advise to only enable this feature with care.\nTurning on body capturing can also significantly increase the overhead in terms of heap usage,\nnetwork utilisation and Elasticsearch index size.").dynamic(true).buildWithDefault(EventType.OFF);
    private final ConfigurationOption<Boolean> captureHeaders = ConfigurationOption.booleanOption().key("capture_headers").configurationCategory("Core").tags("performance").description("If set to `true`, the agent will capture HTTP request and response headers (including cookies), \nas well as messages' headers/properties when using messaging frameworks like Kafka or JMS.\n\nNOTE: Setting this to `false` reduces network bandwidth, disk space and object allocations.").dynamic(true).buildWithDefault(true);
    private final ConfigurationOption<Map<String, String>> globalLabels = ConfigurationOption.builder(new MapValueConverter<String, String>(StringValueConverter.INSTANCE, StringValueConverter.INSTANCE, "=", ","), Map.class).key("global_labels").tags("added[1.7.0, Requires APM Server 7.2+]").configurationCategory("Core").description("Labels added to all events, with the format `key=value[,key=value[,...]]`.\nAny labels set by application via the API will override global labels with the same keys.\n\nNOTE: This feature requires APM Server 7.2+").dynamic(false).buildWithDefault(Collections.emptyMap());
    private final ConfigurationOption<Boolean> typePoolCache = ConfigurationOption.booleanOption().key("enable_type_pool_cache").configurationCategory("Core").tags("internal").description("When enabled, configures Byte Buddy to use a type pool cache.").buildWithDefault(true);
    private final ConfigurationOption<Boolean> warmupByteBuddy = ConfigurationOption.booleanOption().key("warmup_byte_buddy").configurationCategory("Core").tags("internal").description("When set to true, configures Byte Buddy to warmup instrumentation processes on the \nattaching thread just before installing the transformer on the JVM Instrumentation.").buildWithDefault(true);
    private final ConfigurationOption<String> bytecodeDumpPath = ConfigurationOption.stringOption().key("bytecode_dump_path").configurationCategory("Core").tags("internal").description("When set, the agent will create a directory in the provided path if such does not already exist and use it to dump bytecode of instrumented classes.").buildWithDefault("");
    private final ConfigurationOption<Boolean> typeMatchingWithNamePreFilter = ConfigurationOption.booleanOption().key("enable_type_matching_name_pre_filtering").configurationCategory("Core").tags("internal").description("When enabled, applies cheap name-based matchers to types before checking the type hierarchy.\nThis speeds up matching but can lead to false negatives,\nfor example when a javax.servlet.Servlet does not contain the word 'Servlet' in the class name.").buildWithDefault(true);
    private final ConfigurationOption<Boolean> classLoadingMatchingPreFilter = ConfigurationOption.booleanOption().key("enable_class_loading_pre_filtering").configurationCategory("Core").tags("internal").description("When enabled, applies class loader match before checking the type hierarchy that relies on CL cache.\nThis speeds up matching but can lead to class-loading-related side effects, for example when a class \nis available somewhere in the classpath where it never gets loaded unless this matching is applied.").buildWithDefault(true);
    private final ConfigurationOption<List<WildcardMatcher>> classesExcludedFromInstrumentation = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("classes_excluded_from_instrumentation").configurationCategory("Core").description("Use to exclude specific classes from being instrumented. In order to exclude entire packages, \nuse wildcards, as in: `com.project.exclude.*`\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(false).buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<List<WildcardMatcher>> defaultClassesExcludedFromInstrumentation = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("classes_excluded_from_instrumentation_default").configurationCategory("Core").tags("internal").description("\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(false).buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("(?-i)org.infinispan*"), WildcardMatcher.valueOf("(?-i)org.apache.xerces*"), WildcardMatcher.valueOf("(?-i)org.jboss.as.*"), WildcardMatcher.valueOf("(?-i)io.undertow.core*"), WildcardMatcher.valueOf("(?-i)org.eclipse.jdt.ecj*"), WildcardMatcher.valueOf("(?-i)org.wildfly.extension.*"), WildcardMatcher.valueOf("(?-i)org.wildfly.security*")));
    private final ConfigurationOption<List<WildcardMatcher>> methodsExcludedFromInstrumentation = ConfigurationOption.builder(new ListValueConverter<WildcardMatcher>(new WildcardMatcherValueConverter()), List.class).key("methods_excluded_from_instrumentation").configurationCategory("Core").tags("internal").description("\n\nThis option supports the wildcard `*`, which matches zero or more characters.\nExamples: `/foo/*/bar/*/baz*`, `*foo*`.\nMatching is case insensitive by default.\nPrepending an element with `(?-i)` makes the matching case sensitive.").dynamic(true).buildWithDefault(Arrays.asList(WildcardMatcher.valueOf("(?-i)_persistence_*")));
    private final ConfigurationOption<List<MethodMatcher>> traceMethods = ConfigurationOption.builder(MethodMatcherValueConverter.LIST, List.class).key("trace_methods").tags("added[1.3.0,Enhancements in 1.4.0, 1.7.0 and 1.9.0]").configurationCategory("Core").description("A list of methods for which to create a transaction or span.\n\nIf you want to monitor a large number of methods,\nuse  <<config-profiling-inferred-spans-enabled, `profiling_inferred_spans_enabled`>> instead.\n\nThis works by instrumenting each matching method to include code that creates a span for the method.\nWhile creating a span is quite cheap in terms of performance,\ninstrumenting a whole code base or a method which is executed in a tight loop leads to significant overhead.\n\nUsing a pointcut-like syntax, you can match based on\n\n - Method modifier (optional) +\n   Example: `public`, `protected`, `private` or `*`\n - Package and class name (wildcards include sub-packages) +\n   Example: `org.example.*`\n - Method name (optional since 1.4.0) +\n   Example: `myMeth*d`\n - Method argument types (optional) +\n   Example: `(*lang.String, int[])`\n - Classes with a specific annotation (optional) +\n   Example: `@*ApplicationScoped`\n - Classes with a specific annotation that is itself annotated with the given meta-annotation (optional) +\n   Example: `@@javax.enterpr*se.context.NormalScope`\n\nThe syntax is `modifier @fully.qualified.AnnotationName fully.qualified.ClassName#methodName(fully.qualified.ParameterType)`.\n\nA few examples:\n\n - `org.example.*` added[1.4.0,Omitting the method is possible since 1.4.0]\n - `org.example.*#*` (before 1.4.0, you need to specify a method matcher)\n - `org.example.MyClass#myMethod`\n - `org.example.MyClass#myMethod()`\n - `org.example.MyClass#myMethod(java.lang.String)`\n - `org.example.MyClass#myMe*od(java.lang.String, int)`\n - `private org.example.MyClass#myMe*od(java.lang.String, *)`\n - `* org.example.MyClas*#myMe*od(*.String, int[])`\n - `public org.example.services.*Service#*`\n - `public @java.inject.ApplicationScoped org.example.*`\n - `public @java.inject.* org.example.*`\n - `public @@javax.enterprise.context.NormalScope org.example.*, public @@jakarta.enterprise.context.NormalScope org.example.*`\n\nNOTE: Only use wildcards if necessary.\nThe more methods you match the more overhead will be caused by the agent.\nAlso note that there is a maximum amount of spans per transaction (see <<config-transaction-max-spans, `transaction_max_spans`>>).\n\nNOTE: The agent will create stack traces for spans which took longer than\n<<config-span-stack-trace-min-duration, `span_stack_trace_min_duration`>>.\nWhen tracing a large number of methods (for example by using wildcards),\nthis may lead to high overhead.\nConsider increasing the threshold or disabling stack trace collection altogether.\n\nCommon configurations:\n\nTrace all public methods in CDI-Annotated beans:\n\n----\npublic @@javax.enterprise.context.NormalScope your.application.package.*\npublic @@jakarta.enterprise.context.NormalScope your.application.package.*\npublic @@javax.inject.Scope your.application.package.*\n----\nNOTE: This method is only available in the Elastic APM Java Agent.\n\nNOTE: Changing this value at runtime can slow down the application temporarily.").dynamic(true).tags("added[1.0.0,Changing this value at runtime is possible since version 1.15.0]").buildWithDefault(Collections.emptyList());
    private final ConfigurationOption<TimeDuration> traceMethodsDurationThreshold = TimeDurationValueConverter.durationOption("ms").key("trace_methods_duration_threshold").tags("added[1.7.0]").configurationCategory("Core").description("If <<config-trace-methods, `trace_methods`>> config option is set, provides a threshold to limit spans based on \nduration. When set to a value greater than 0, spans representing methods traced based on `trace_methods` will be discarded by default.\nSuch methods will be traced and reported if one of the following applies:\n\n - This method's duration crossed the configured threshold.\n - This method ended with Exception.\n - A method executed as part of the execution of this method crossed the threshold or ended with Exception.\n - A \"forcibly-traced method\" (e.g. DB queries, HTTP exits, custom) was executed during the execution of this method.\n\nSet to 0 to disable.\n\nNOTE: Transactions are never discarded, regardless of their duration.\nThis configuration affects only spans.\nIn order not to break span references,\nall spans leading to an async operation or an exit span (such as a HTTP request or a DB query) are never discarded,\nregardless of their duration.\n\nNOTE: If this option and <<config-span-min-duration,`span_min_duration`>> are both configured,\nthe higher of both thresholds will determine which spans will be discarded.").buildWithDefault(TimeDuration.of("0ms"));
    private final ConfigurationOption<Boolean> centralConfig = ConfigurationOption.booleanOption().key("central_config").tags("added[1.8.0]").configurationCategory("Core").description("When enabled, the agent will make periodic requests to the APM Server to fetch updated configuration.").dynamic(true).buildWithDefault(true);
    private final ConfigurationOption<Boolean> breakdownMetrics = ConfigurationOption.booleanOption().key("breakdown_metrics").tags("added[1.8.0]").configurationCategory("Core").description("Disables the collection of breakdown metrics (`span.self_time`)").buildWithDefault(true);
    private final ConfigurationOption<String> configFileLocation = ConfigurationOption.stringOption().key("config_file").tags("added[1.8.0]").configurationCategory("Core").description("Sets the path of the agent config file.\nThe special value `_AGENT_HOME_` is a placeholder for the folder the `elastic-apm-agent.jar` is in.\nThe file has to be on the file system.\nYou can not refer to classpath locations.\n\nNOTE: this option can only be set via system properties, environment variables or the attacher options.").buildWithDefault("_AGENT_HOME_/elasticapm.properties");
    private final ConfigurationOption<String> pluginsDirLocation = ConfigurationOption.stringOption().key("plugins_dir").tags("added[1.18.0]").configurationCategory("Core").tags("experimental").description("A folder that contains external agent plugins.\n\nUse the `apm-agent-plugin-sdk` and the `apm-agent-api` artifacts to create a jar and place it into the plugins folder.\nThe agent will load all instrumentations that are declared in the\n`META-INF/services/co.elastic.apm.agent.sdk.ElasticApmInstrumentation` service descriptor.\nSee `integration-tests/external-plugin-test` for an example plugin.").build();
    private final ConfigurationOption<Boolean> useElasticTraceparentHeader = ConfigurationOption.booleanOption().key("use_elastic_traceparent_header").tags("added[1.14.0]").configurationCategory("Core").description("To enable {apm-guide-ref}/apm-distributed-tracing.html[distributed tracing], the agent\nadds trace context headers to outgoing requests (like HTTP requests, Kafka records, gRPC requests etc.).\nThese headers (`traceparent` and `tracestate`) are defined in the\nhttps://www.w3.org/TR/trace-context-1/[W3C Trace Context] specification.\n\nWhen this setting is `true`, the agent will also add the header `elastic-apm-traceparent`\nfor backwards compatibility with older versions of Elastic APM agents.").dynamic(true).buildWithDefault(true);
    private final ConfigurationOption<Integer> tracestateHeaderSizeLimit = ConfigurationOption.integerOption().key("tracestate_header_size_limit").tags("added[1.14.0]").configurationCategory("Core").description("The agent delegates the `tracestate` header, if received, as defined in the\nhttps://www.w3.org/TR/trace-context-1/[W3C Trace Context] specification.\n\nThis setting limits the size of the `tracestate` header.").dynamic(true).tags("internal").buildWithDefault(4096);
    private final ConfigurationOption<TimeDuration> spanMinDuration = TimeDurationValueConverter.durationOption("ms").key("span_min_duration").tags("added[1.16.0]").configurationCategory("Core").description("Sets the minimum duration of spans.\nSpans that execute faster than this threshold are attempted to be discarded.\n\nThe attempt fails if they lead up to a span that can't be discarded.\nSpans that propagate the trace context to downstream services,\nsuch as outgoing HTTP requests,\ncan't be discarded.\nAdditionally, spans that lead to an error or that may be a parent of an async operation can't be discarded.\n\nHowever, external calls that don't propagate context,\nsuch as calls to a database, can be discarded using this threshold.").dynamic(true).buildWithDefault(TimeDuration.of("0ms"));
    private final ConfigurationOption<CloudProvider> cloudProvider = ConfigurationOption.enumOption(CloudProvider.class).key("cloud_provider").tags("added[1.21.0]").configurationCategory("Core").description("This config value allows you to specify which cloud provider should be assumed \nfor metadata collection. By default, the agent will attempt to detect the cloud \nprovider or, if that fails, will use trial and error to collect the metadata.").buildWithDefault(CloudProvider.AUTO);
    private final ConfigurationOption<TimeDuration> metadataTimeoutMs = TimeDurationValueConverter.durationOption("ms").key("metadata_timeout_ms").configurationCategory("Core").tags("internal").description("Some metadata auto-discovery tasks require long execution. For example, cloud provider information \nis fetched by querying APIs through HTTP and hostname discovery relies on running external commands. \nIn some cases, such discovery tasks rely on trial-and-error. This config option is used to limit the time \nspent on metadata discovery. Wherever possible, these tasks are executed in parallel, but in some cases \nthey can't be, which means that this config doesn't indicate the absolute limit for the entire metadata \ndiscovery. Rather, it defines the timeout for each metadata discovery task.").buildWithDefault(TimeDuration.of("1000ms"));
    private final ConfigurationOption<Boolean> enablePublicApiAnnotationInheritance = ConfigurationOption.booleanOption().key("enable_public_api_annotation_inheritance").tags("added[1.25.0]").configurationCategory("Core").tags("performance").description("A boolean specifying if the agent should search the class hierarchy for public api annotations (@CaptureTransaction, @CaptureSpan, @Traced)).\n When set to `false`, a method is instrumented if it is annotated with a public api annotation.\n  When set to `true` methods overriding annotated methods will be instrumented as well.\n Either way, methods will only be instrumented if they are included in the configured <<config-application-packages>>.").dynamic(false).buildWithDefault(false);

    public boolean isEnabled() {
        return this.enabled.get();
    }

    public boolean isInstrument() {
        return this.instrument.get();
    }

    public List<ConfigurationOption<?>> getInstrumentationOptions() {
        return Arrays.asList(this.instrument, this.traceMethods, this.enabledInstrumentations, this.disabledInstrumentations, this.enableExperimentalInstrumentations);
    }

    public String getServiceName() {
        return this.serviceName.get();
    }

    public ConfigurationOption<String> getServiceNameConfig() {
        return this.serviceName;
    }

    @Nullable
    public String getServiceNodeName() {
        String nodeName = this.serviceNodeName.get();
        if (nodeName == null || nodeName.trim().isEmpty()) {
            return null;
        }
        return nodeName;
    }

    public long getDelayTracerStartMs() {
        return this.delayTracerStart.get().getMillis();
    }

    @Nullable
    public String getServiceVersion() {
        return this.serviceVersion.get();
    }

    @Nullable
    public String getHostname() {
        return this.hostname.get();
    }

    @Nullable
    public String getEnvironment() {
        return this.environment.get();
    }

    public ConfigurationOption<Double> getSampleRate() {
        return this.sampleRate;
    }

    public int getTransactionMaxSpans() {
        return this.transactionMaxSpans.get();
    }

    public List<WildcardMatcher> getSanitizeFieldNames() {
        return this.sanitizeFieldNames.get();
    }

    public boolean isInstrumentationEnabled(String instrumentationGroupName) {
        Collection<String> enabledInstrumentationGroupNames = this.enabledInstrumentations.get();
        Collection<String> disabledInstrumentationGroupNames = this.disabledInstrumentations.get();
        return !(!enabledInstrumentationGroupNames.isEmpty() && !enabledInstrumentationGroupNames.contains(instrumentationGroupName) || disabledInstrumentationGroupNames.contains(instrumentationGroupName) || this.enableExperimentalInstrumentations.get() == false && instrumentationGroupName.equals("experimental"));
    }

    public boolean isInstrumentationEnabled(Collection<String> instrumentationGroupNames) {
        return this.isGroupEnabled(instrumentationGroupNames) && !this.isGroupDisabled(instrumentationGroupNames);
    }

    private boolean isGroupEnabled(Collection<String> instrumentationGroupNames) {
        Collection<String> enabledInstrumentationGroupNames = this.enabledInstrumentations.get();
        if (enabledInstrumentationGroupNames.isEmpty()) {
            return true;
        }
        for (String instrumentationGroupName : instrumentationGroupNames) {
            if (!enabledInstrumentationGroupNames.contains(instrumentationGroupName)) continue;
            return true;
        }
        return false;
    }

    private boolean isGroupDisabled(Collection<String> instrumentationGroupNames) {
        Collection<String> disabledInstrumentationGroupNames = this.disabledInstrumentations.get();
        for (String instrumentationGroupName : instrumentationGroupNames) {
            if (!disabledInstrumentationGroupNames.contains(instrumentationGroupName)) continue;
            return true;
        }
        return this.enableExperimentalInstrumentations.get() == false && instrumentationGroupNames.contains("experimental");
    }

    public List<WildcardMatcher> getUnnestExceptions() {
        return this.unnestExceptions.get();
    }

    public List<WildcardMatcher> getIgnoreExceptions() {
        return this.ignoreExceptions.get();
    }

    public EventType getCaptureBody() {
        return this.captureBody.get();
    }

    public boolean isCaptureHeaders() {
        return this.captureHeaders.get();
    }

    public boolean isTypePoolCacheEnabled() {
        return this.typePoolCache.get();
    }

    public boolean shouldWarmupByteBuddy() {
        return this.warmupByteBuddy.get();
    }

    @Nullable
    public String getBytecodeDumpPath() {
        return this.bytecodeDumpPath.get();
    }

    public boolean isTypeMatchingWithNamePreFilter() {
        return this.typeMatchingWithNamePreFilter.get();
    }

    public boolean isClassLoadingMatchingPreFilter() {
        return this.classLoadingMatchingPreFilter.get();
    }

    public List<WildcardMatcher> getClassesExcludedFromInstrumentation() {
        return this.classesExcludedFromInstrumentation.get();
    }

    public List<WildcardMatcher> getDefaultClassesExcludedFromInstrumentation() {
        return this.defaultClassesExcludedFromInstrumentation.get();
    }

    public List<WildcardMatcher> getMethodsExcludedFromInstrumentation() {
        return this.methodsExcludedFromInstrumentation.get();
    }

    public List<MethodMatcher> getTraceMethods() {
        return this.traceMethods.get();
    }

    public TimeDuration getTraceMethodsDurationThreshold() {
        return this.traceMethodsDurationThreshold.get();
    }

    public Map<String, String> getGlobalLabels() {
        return this.globalLabels.get();
    }

    boolean isCentralConfigEnabled() {
        return this.centralConfig.get();
    }

    public boolean isBreakdownMetricsEnabled() {
        return this.breakdownMetrics.get();
    }

    public boolean isElasticTraceparentHeaderEnabled() {
        return this.useElasticTraceparentHeader.get();
    }

    public int getTracestateSizeLimit() {
        return this.tracestateHeaderSizeLimit.get();
    }

    public TimeDuration getSpanMinDuration() {
        return this.spanMinDuration.get();
    }

    @Nullable
    public static String getConfigFileLocation(List<ConfigurationSource> configurationSources, boolean premain) {
        String agentHome;
        String configFileLocation = premain ? DEFAULT_CONFIG_FILE : null;
        for (ConfigurationSource source : configurationSources) {
            String value = source.getValue(CONFIG_FILE);
            if (value == null) continue;
            configFileLocation = value;
            break;
        }
        if (configFileLocation != null && (agentHome = ElasticApmAgent.getAgentHome()) != null) {
            configFileLocation = configFileLocation.replace("_AGENT_HOME_", agentHome);
        }
        return configFileLocation;
    }

    @Nullable
    public String getPluginsDir() {
        String configFileLocation = this.pluginsDirLocation.get();
        if (configFileLocation != null && configFileLocation.contains("_AGENT_HOME_")) {
            String agentHome = ElasticApmAgent.getAgentHome();
            if (agentHome != null) {
                return configFileLocation.replace("_AGENT_HOME_", agentHome);
            }
            return null;
        }
        return configFileLocation;
    }

    public long getMetadataDiscoveryTimeoutMs() {
        return this.metadataTimeoutMs.get().getMillis();
    }

    public CloudProvider getCloudProvider() {
        return this.cloudProvider.get();
    }

    public boolean isEnablePublicApiAnnotationInheritance() {
        return this.enablePublicApiAnnotationInheritance.get();
    }

    public static enum CloudProvider {
        AUTO,
        AWS,
        GCP,
        AZURE,
        NONE;

    }

    public static enum EventType {
        OFF,
        ERRORS,
        TRANSACTIONS,
        ALL;


        public String toString() {
            return this.name().toLowerCase();
        }
    }
}

