/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.bci;

import co.elastic.apm.agent.bci.ElasticApmAgent;
import co.elastic.apm.agent.bci.InstrumentationStats;
import co.elastic.apm.agent.bci.bytebuddy.MatcherTimer;
import co.elastic.apm.agent.context.AbstractLifecycleListener;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.sdk.logging.Logger;
import co.elastic.apm.agent.sdk.logging.LoggerFactory;
import java.util.ArrayList;
import java.util.Collections;

public class InstrumentationStatsLifecycleListener
extends AbstractLifecycleListener {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentationStatsLifecycleListener.class);

    @Override
    public void init(ElasticApmTracer tracer) {
        InstrumentationStats instrumentationStats = ElasticApmAgent.getInstrumentationStats();
        instrumentationStats.reset();
        instrumentationStats.setMeasureMatching(logger.isDebugEnabled());
    }

    @Override
    public void stop() {
        InstrumentationStats instrumentationStats = ElasticApmAgent.getInstrumentationStats();
        logger.info("Used instrumentation groups: {}", (Object)instrumentationStats.getUsedInstrumentationGroups());
        if (instrumentationStats.shouldMeasureMatching()) {
            ArrayList<MatcherTimer> matcherTimers = new ArrayList<MatcherTimer>(instrumentationStats.getMatcherTimers());
            Collections.sort(matcherTimers);
            StringBuilder sb = new StringBuilder().append("Total time spent matching: ").append(String.format("%,d", instrumentationStats.getTotalMatcherTime())).append("ns").append('\n').append(MatcherTimer.getTableHeader()).append('\n');
            for (MatcherTimer matcherTimer : matcherTimers) {
                sb.append(matcherTimer.toString()).append('\n');
            }
            logger.debug(sb.toString());
        }
    }
}

