/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2;

import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Publisher;
import software.amazon.awssdk.core.Response;
import software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import software.amazon.awssdk.http.SdkHttpResponse;

public class ResponseHandlerWrapper<T>
implements TransformingAsyncResponseHandler<Response<T>> {
    private final TransformingAsyncResponseHandler<Response<T>> delegate;
    private final Span span;

    public ResponseHandlerWrapper(TransformingAsyncResponseHandler<Response<T>> delegate, Span span) {
        this.delegate = delegate;
        this.span = span;
    }

    public CompletableFuture<Response<T>> prepare() {
        CompletableFuture delegateFuture = this.delegate.prepare();
        delegateFuture.whenComplete((r, t) -> {
            if (t != null) {
                this.span.captureException((Throwable)t);
                this.span.withOutcome(Outcome.FAILURE);
            } else if (r.exception() != null) {
                this.span.captureException((Throwable)r.exception());
                this.span.withOutcome(Outcome.FAILURE);
            } else {
                this.span.withOutcome(Outcome.SUCCESS);
            }
            this.span.end();
        });
        return delegateFuture;
    }

    public void onHeaders(SdkHttpResponse sdkHttpResponse) {
        this.delegate.onHeaders(sdkHttpResponse);
    }

    public void onStream(Publisher<ByteBuffer> publisher) {
        this.delegate.onStream(publisher);
    }

    public void onError(Throwable throwable) {
        if (!this.span.isFinished()) {
            this.span.captureException(throwable);
            this.span.withOutcome(Outcome.FAILURE);
        }
        this.delegate.onError(throwable);
    }
}

