/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2;

import co.elastic.apm.agent.awssdk.v2.helper.DynamoDbHelper;
import co.elastic.apm.agent.awssdk.v2.helper.S3Helper;
import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class BaseSyncClientHandlerInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("software.amazon.awssdk.core.internal.handler.BaseSyncClientHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("invoke").and(ElementMatchers.takesArgument(0, ElementMatchers.named("software.amazon.awssdk.http.SdkHttpFullRequest"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("software.amazon.awssdk.core.SdkRequest"))).and(ElementMatchers.takesArgument(2, ElementMatchers.named("software.amazon.awssdk.core.http.ExecutionContext")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("aws-sdk");
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Nullable
        public static Object enterInvoke(@Advice.Argument(value=0) SdkHttpFullRequest sdkHttpFullRequest, @Advice.Argument(value=1) SdkRequest sdkRequest, @Advice.Argument(value=2) ExecutionContext executionContext) {
            String awsService = (String)executionContext.executionAttributes().getAttribute(AwsSignerExecutionAttribute.SERVICE_NAME);
            Span span = null;
            if ("S3".equalsIgnoreCase(awsService)) {
                span = S3Helper.getInstance().startSpan(sdkRequest, sdkHttpFullRequest.getUri(), executionContext);
            } else if ("DynamoDb".equalsIgnoreCase(awsService)) {
                span = DynamoDbHelper.getInstance().startSpan(sdkRequest, sdkHttpFullRequest.getUri(), executionContext);
            }
            if (span != null) {
                span.activate();
            }
            return span;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static void exitInvoke(@Nullable @Advice.Enter Object spanObj, @Nullable @Advice.Thrown Throwable thrown) {
            if (spanObj instanceof Span) {
                Span span = (Span)spanObj;
                span.deactivate();
                if (thrown != null) {
                    span.captureException(thrown);
                    span.withOutcome(Outcome.FAILURE);
                } else {
                    span.withOutcome(Outcome.SUCCESS);
                }
                span.end();
            }
        }
    }
}

