/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v2;

import co.elastic.apm.agent.awssdk.v2.ResponseHandlerWrapper;
import co.elastic.apm.agent.awssdk.v2.helper.DynamoDbHelper;
import co.elastic.apm.agent.awssdk.v2.helper.S3Helper;
import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Span;
import java.util.Collection;
import java.util.Collections;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import software.amazon.awssdk.auth.signer.AwsSignerExecutionAttribute;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.http.ExecutionContext;
import software.amazon.awssdk.core.internal.http.TransformingAsyncResponseHandler;
import software.amazon.awssdk.http.SdkHttpFullRequest;

public class BaseAsyncClientHandlerInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("software.amazon.awssdk.core.internal.handler.BaseAsyncClientHandler");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("invoke").and(ElementMatchers.takesArgument(0, ElementMatchers.named("software.amazon.awssdk.http.SdkHttpFullRequest"))).and(ElementMatchers.takesArgument(3, ElementMatchers.named("software.amazon.awssdk.core.http.ExecutionContext")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("aws-sdk");
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Advice.AssignReturned.ToArguments(value={@Advice.AssignReturned.ToArguments.ToArgument(value=4)})
        public static TransformingAsyncResponseHandler<?> enterInvoke(@Advice.Argument(value=0) SdkHttpFullRequest sdkHttpFullRequest, @Advice.Argument(value=2) Object sdkRequestObj, @Advice.Argument(value=3) ExecutionContext executionContext, @Advice.Argument(value=4) TransformingAsyncResponseHandler<?> responseHandler) {
            if (sdkRequestObj instanceof SdkRequest) {
                String awsService = (String)executionContext.executionAttributes().getAttribute(AwsSignerExecutionAttribute.SERVICE_NAME);
                Span span = null;
                if ("S3".equalsIgnoreCase(awsService)) {
                    span = S3Helper.getInstance().startSpan((SdkRequest)sdkRequestObj, sdkHttpFullRequest.getUri(), executionContext);
                } else if ("DynamoDb".equalsIgnoreCase(awsService)) {
                    span = DynamoDbHelper.getInstance().startSpan((SdkRequest)sdkRequestObj, sdkHttpFullRequest.getUri(), executionContext);
                }
                if (span != null) {
                    span.withSync(false);
                    return new ResponseHandlerWrapper(responseHandler, span);
                }
            }
            return responseHandler;
        }
    }
}

