/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1.helper;

import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import co.elastic.apm.agent.awssdk.v1.helper.DynamoDbHelper;
import com.amazonaws.Request;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import com.amazonaws.services.dynamodbv2.model.QueryRequest;
import javax.annotation.Nullable;

public class SdkV1DataSource
implements IAwsSdkDataSource<Request<?>, ExecutionContext> {
    @Nullable
    private static SdkV1DataSource INSTANCE;

    public static SdkV1DataSource getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SdkV1DataSource();
        }
        return INSTANCE;
    }

    @Override
    @Nullable
    public String getOperationName(Request<?> request, ExecutionContext context) {
        return (String)request.getHandlerContext(HandlerContextKey.OPERATION_NAME);
    }

    @Override
    @Nullable
    public String getRegion(Request<?> request, ExecutionContext context) {
        return (String)request.getHandlerContext(HandlerContextKey.SIGNING_REGION);
    }

    @Override
    @Nullable
    public String getFieldValue(String fieldName, Request<?> request, ExecutionContext context) {
        if ("Bucket".equals(fieldName)) {
            int idx;
            String resourcePath = request.getResourcePath();
            if (resourcePath == null || resourcePath.isEmpty()) {
                return null;
            }
            if (resourcePath.startsWith("/")) {
                resourcePath = resourcePath.substring(1);
            }
            return (idx = resourcePath.indexOf(47)) < 0 ? resourcePath : resourcePath.substring(0, idx);
        }
        if ("TableName".equals(fieldName)) {
            return DynamoDbHelper.getInstance().getTableName(request.getOriginalRequest());
        }
        if ("KeyConditionExpression".equals(fieldName) && request.getOriginalRequest() instanceof QueryRequest) {
            return ((QueryRequest)request.getOriginalRequest()).getKeyConditionExpression();
        }
        return null;
    }
}

