/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1;

import co.elastic.apm.agent.awssdk.v1.helper.DynamoDbHelper;
import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class DynamoDBGetTableNameInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.nameStartsWith("com.amazonaws.services.dynamodbv2.model.").and(ElementMatchers.nameEndsWith("Request")).and(ElementMatchers.declaresMethod(ElementMatchers.named("getTableName")));
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("getTableName");
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("aws-sdk");
    }

    public static class AdviceClass {
        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static void exitGetTableName(@Advice.This Object requestObject, @Nullable @Advice.Return String tableName) {
            if (tableName != null && !DynamoDbHelper.getInstance().hasTableNameForKey(requestObject)) {
                DynamoDbHelper.getInstance().putTableName(requestObject, tableName);
            }
        }
    }
}

