/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.v1;

import co.elastic.apm.agent.awssdk.v1.helper.DynamoDbHelper;
import co.elastic.apm.agent.awssdk.v1.helper.S3Helper;
import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import com.amazonaws.Request;
import com.amazonaws.handlers.HandlerContextKey;
import com.amazonaws.http.ExecutionContext;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class AmazonHttpClientInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("com.amazonaws.http.AmazonHttpClient");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.named("execute").and(ElementMatchers.takesArguments(5)).and(ElementMatchers.takesArgument(0, ElementMatchers.named("com.amazonaws.Request"))).and(ElementMatchers.takesArgument(3, ElementMatchers.named("com.amazonaws.http.ExecutionContext")));
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("aws-sdk");
    }

    public static class AdviceClass {
        @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
        @Nullable
        public static Object enterInvoke(@Advice.Argument(value=0) Request<?> request, @Advice.Argument(value=3) ExecutionContext executionContext) {
            String awsService = (String)request.getHandlerContext(HandlerContextKey.SERVICE_ID);
            Span span = null;
            if (awsService.startsWith("S3")) {
                span = S3Helper.getInstance().startSpan(request, request.getEndpoint(), executionContext);
            } else if ("DynamoDB".equalsIgnoreCase(awsService)) {
                span = DynamoDbHelper.getInstance().startSpan(request, request.getEndpoint(), executionContext);
                DynamoDbHelper.getInstance().removeTableNameForKey(request.getOriginalRequest());
            }
            if (span != null) {
                span.activate();
            }
            return span;
        }

        @Advice.OnMethodExit(suppress=Throwable.class, inline=false, onThrowable=Throwable.class)
        public static void exitInvoke(@Nullable @Advice.Enter Object spanObj, @Nullable @Advice.Thrown Throwable thrown) {
            if (spanObj instanceof Span) {
                Span span = (Span)spanObj;
                span.deactivate();
                if (thrown != null) {
                    span.captureException(thrown);
                    span.withOutcome(Outcome.FAILURE);
                } else {
                    span.withOutcome(Outcome.SUCCESS);
                }
                span.end();
            }
        }
    }
}

