/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.common;

import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.URI;
import javax.annotation.Nullable;

public abstract class AbstractS3InstrumentationHelper<R, C> {
    private static final String S3_TYPE = "s3";
    private final IAwsSdkDataSource<R, C> awsSdkDataSource;
    private final ElasticApmTracer tracer;

    protected AbstractS3InstrumentationHelper(ElasticApmTracer tracer, IAwsSdkDataSource<R, C> awsSdkDataSource) {
        this.tracer = tracer;
        this.awsSdkDataSource = awsSdkDataSource;
    }

    @Nullable
    public Span startSpan(R request, URI httpURI, C context) {
        Span span = this.tracer.createExitChildSpan();
        if (span == null) {
            return null;
        }
        String operationName = this.awsSdkDataSource.getOperationName(request, context);
        String region = this.awsSdkDataSource.getRegion(request, context);
        String bucketName = this.awsSdkDataSource.getFieldValue("Bucket", request, context);
        ((Span)span.withType("storage")).withSubtype(S3_TYPE).withAction(operationName);
        span.getContext().getDb().withInstance(region).withType(S3_TYPE);
        StringBuilder name = span.getAndOverrideName(0);
        if (operationName != null && name != null) {
            name.append("S3 ").append(operationName);
            if (bucketName != null && !bucketName.isEmpty()) {
                name.append(" ").append(bucketName);
            }
        }
        span.withName("S3", -1);
        span.getContext().getServiceTarget().withType(S3_TYPE).withName(bucketName).withNameOnlyDestinationResource();
        span.getContext().getDestination().withAddress(httpURI.getHost()).withPort(httpURI.getPort());
        return span;
    }
}

