/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awssdk.common;

import co.elastic.apm.agent.awssdk.common.IAwsSdkDataSource;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.Span;
import java.net.URI;
import javax.annotation.Nullable;

public abstract class AbstractDynamoDBInstrumentationHelper<R, C> {
    private static final String DYNAMO_DB_TYPE = "dynamodb";
    private final IAwsSdkDataSource<R, C> awsSdkDataSource;
    private final ElasticApmTracer tracer;

    protected AbstractDynamoDBInstrumentationHelper(ElasticApmTracer tracer, IAwsSdkDataSource<R, C> awsSdkDataSource) {
        this.tracer = tracer;
        this.awsSdkDataSource = awsSdkDataSource;
    }

    public void enrichSpan(Span span, R sdkRequest, URI httpURI, C context) {
        StringBuilder name;
        String operationName = this.awsSdkDataSource.getOperationName(sdkRequest, context);
        String region = this.awsSdkDataSource.getRegion(sdkRequest, context);
        String tableName = this.awsSdkDataSource.getFieldValue("TableName", sdkRequest, context);
        ((Span)span.withType("db")).withSubtype(DYNAMO_DB_TYPE).withAction("query");
        span.getContext().getDb().withInstance(region).withType(DYNAMO_DB_TYPE);
        if (operationName.equals("Query")) {
            span.getContext().getDb().withStatement(this.awsSdkDataSource.getFieldValue("KeyConditionExpression", sdkRequest, context));
        }
        if ((name = span.getAndOverrideName(0)) != null) {
            name.append("DynamoDB ").append(operationName);
            if (tableName != null) {
                name.append(" ").append(tableName);
            }
        }
        span.getContext().getServiceTarget().withType(DYNAMO_DB_TYPE);
        span.getContext().getDestination().withAddress(httpURI.getHost()).withPort(httpURI.getPort());
    }

    @Nullable
    public Span startSpan(R sdkRequest, URI httpURI, C context) {
        Span span = this.tracer.createExitChildSpan();
        if (span == null) {
            return null;
        }
        this.enrichSpan(span, sdkRequest, httpURI, context);
        return span;
    }
}

