/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.SQSMessageAttributesGetter;
import co.elastic.apm.agent.awslambda.helper.AbstractMessageBasedTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import java.util.List;
import javax.annotation.Nullable;

public class SQSTransactionHelper
extends AbstractMessageBasedTransactionHelper<SQSEvent, Void, SQSEvent.SQSMessage> {
    @Nullable
    private static SQSTransactionHelper INSTANCE;
    private final SQSEvent.SQSMessage placeholderMessage = new SQSEvent.SQSMessage();

    private SQSTransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    public static SQSTransactionHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SQSTransactionHelper(GlobalTracer.requireTracerImpl());
        }
        return INSTANCE;
    }

    @Override
    protected String getAWSService() {
        return "sqs";
    }

    @Override
    @Nullable
    protected String getQueueArn(SQSEvent.SQSMessage record) {
        return record.getEventSourceArn();
    }

    @Override
    protected String getRegion(SQSEvent.SQSMessage record) {
        return record.getAwsRegion();
    }

    @Override
    protected String getVersion(SQSEvent.SQSMessage record) {
        return null;
    }

    @Override
    protected SQSEvent.SQSMessage getFirstRecord(SQSEvent event) {
        SQSEvent.SQSMessage record = null;
        if (null != event.getRecords() && !event.getRecords().isEmpty()) {
            record = (SQSEvent.SQSMessage)event.getRecords().get(0);
        }
        return record != null ? record : this.placeholderMessage;
    }

    @Override
    protected void addSpanLinks(Transaction transaction, SQSEvent event) {
        List records = event.getRecords();
        if (records != null && !records.isEmpty()) {
            for (SQSEvent.SQSMessage record : records) {
                transaction.addSpanLink(TraceContext.getFromTraceContextTextHeaders(), SQSMessageAttributesGetter.INSTANCE, record);
            }
        }
    }
}

