/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.SNSMessageAttributesGetter;
import co.elastic.apm.agent.awslambda.helper.AbstractMessageBasedTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.TraceContext;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import java.util.List;
import javax.annotation.Nullable;

public class SNSTransactionHelper
extends AbstractMessageBasedTransactionHelper<SNSEvent, Void, SNSEvent.SNSRecord> {
    @Nullable
    private static SNSTransactionHelper INSTANCE;
    private final SNSEvent.SNSRecord placeholderRecord = new SNSEvent.SNSRecord();

    private SNSTransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    public static SNSTransactionHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new SNSTransactionHelper(GlobalTracer.requireTracerImpl());
        }
        return INSTANCE;
    }

    @Override
    protected String getAWSService() {
        return "sns";
    }

    @Override
    protected String getQueueArn(SNSEvent.SNSRecord record) {
        if (null != record.getSNS()) {
            return record.getSNS().getTopicArn();
        }
        return null;
    }

    @Override
    protected String getRegion(SNSEvent.SNSRecord record) {
        return null;
    }

    @Override
    protected String getVersion(SNSEvent.SNSRecord record) {
        return record.getEventVersion();
    }

    @Override
    protected SNSEvent.SNSRecord getFirstRecord(SNSEvent event) {
        SNSEvent.SNSRecord record = null;
        if (null != event.getRecords() && !event.getRecords().isEmpty()) {
            record = (SNSEvent.SNSRecord)event.getRecords().get(0);
        }
        return record != null ? record : this.placeholderRecord;
    }

    @Override
    protected void addSpanLinks(Transaction transaction, SNSEvent event) {
        List records = event.getRecords();
        if (records != null && !records.isEmpty()) {
            for (SNSEvent.SNSRecord record : records) {
                transaction.addSpanLink(TraceContext.getFromTraceContextTextHeaders(), SNSMessageAttributesGetter.INSTANCE, record);
            }
        }
    }
}

