/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.helper.AbstractLambdaTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.context.CloudOrigin;
import co.elastic.apm.agent.impl.context.ServiceOrigin;
import co.elastic.apm.agent.impl.transaction.FaasTrigger;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.S3Event;
import com.amazonaws.services.lambda.runtime.events.models.s3.S3EventNotification;
import javax.annotation.Nullable;

public class S3TransactionHelper
extends AbstractLambdaTransactionHelper<S3Event, Void> {
    protected static final String TRANSACTION_TYPE = "messaging";
    @Nullable
    private static S3TransactionHelper INSTANCE;

    private S3TransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    public static S3TransactionHelper getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new S3TransactionHelper(GlobalTracer.requireTracerImpl());
        }
        return INSTANCE;
    }

    @Override
    @Nullable
    protected Transaction doStartTransaction(S3Event s3Event, Context lambdaContext) {
        return this.tracer.startRootTransaction(lambdaContext.getClass().getClassLoader());
    }

    @Override
    public void captureOutputForTransaction(Transaction transaction, Void output) {
    }

    @Override
    protected void setTransactionTriggerData(Transaction transaction, S3Event s3Event) {
        transaction.withType(TRANSACTION_TYPE);
        FaasTrigger faasTrigger = transaction.getFaas().getTrigger();
        faasTrigger.withType("datasource");
        CloudOrigin cloudOrigin = transaction.getContext().getCloudOrigin();
        cloudOrigin.withProvider("aws").withServiceName("s3");
        S3EventNotification.S3EventNotificationRecord s3NotificationRecord = this.getS3NotificationRecord(s3Event);
        if (null != s3NotificationRecord) {
            String requestId = null != s3NotificationRecord.getResponseElements() ? s3NotificationRecord.getResponseElements().getxAmzRequestId() : null;
            faasTrigger.withRequestId(requestId);
            cloudOrigin.withRegion(s3NotificationRecord.getAwsRegion());
            if (null != s3NotificationRecord.getS3() && null != s3NotificationRecord.getS3().getBucket()) {
                S3EventNotification.S3BucketEntity bucket = s3NotificationRecord.getS3().getBucket();
                ServiceOrigin serviceOrigin = transaction.getContext().getServiceOrigin();
                serviceOrigin.withId(bucket.getArn());
                serviceOrigin.withName(bucket.getName());
                serviceOrigin.withVersion(s3NotificationRecord.getEventVersion());
            }
        }
    }

    @Override
    protected void setTransactionName(Transaction transaction, S3Event s3Event, Context lambdaContext) {
        S3EventNotification.S3EventNotificationRecord s3NotificationRecord = this.getS3NotificationRecord(s3Event);
        StringBuilder transactionName = transaction.getAndOverrideName(100);
        if (transactionName != null && null != s3NotificationRecord && null != s3NotificationRecord.getS3() && null != s3NotificationRecord.getS3().getBucket()) {
            transactionName.append(s3NotificationRecord.getEventName()).append(" ").append(s3NotificationRecord.getS3().getBucket().getName());
        } else {
            super.setTransactionName(transaction, s3Event, lambdaContext);
        }
    }

    @Nullable
    private S3EventNotification.S3EventNotificationRecord getS3NotificationRecord(S3Event s3Event) {
        if (null != s3Event.getRecords() && s3Event.getRecords().size() == 1) {
            return (S3EventNotification.S3EventNotificationRecord)s3Event.getRecords().get(0);
        }
        return null;
    }
}

