/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.helper.AbstractLambdaTransactionHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.context.CloudOrigin;
import co.elastic.apm.agent.impl.context.ServiceOrigin;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.Context;
import javax.annotation.Nullable;

public abstract class AbstractMessageBasedTransactionHelper<I, O, R>
extends AbstractLambdaTransactionHelper<I, O> {
    protected static final String TRANSACTION_TYPE = "messaging";

    protected AbstractMessageBasedTransactionHelper(ElasticApmTracer tracer) {
        super(tracer);
    }

    protected abstract String getAWSService();

    @Nullable
    protected abstract String getQueueArn(R var1);

    @Nullable
    protected abstract String getRegion(R var1);

    @Nullable
    protected abstract String getVersion(R var1);

    protected abstract R getFirstRecord(I var1);

    @Override
    @Nullable
    protected Transaction doStartTransaction(I event, Context lambdaContext) {
        Transaction transaction = this.tracer.startRootTransaction(lambdaContext.getClass().getClassLoader());
        if (null != transaction) {
            this.addSpanLinks(transaction, event);
        }
        return transaction;
    }

    protected abstract void addSpanLinks(Transaction var1, I var2);

    @Override
    public void captureOutputForTransaction(Transaction transaction, O output) {
    }

    @Override
    protected void setTransactionTriggerData(Transaction transaction, I event) {
        R record = this.getFirstRecord(event);
        transaction.withType(TRANSACTION_TYPE);
        transaction.getFaas().getTrigger().withType("pubsub");
        ServiceOrigin serviceOrigin = transaction.getContext().getServiceOrigin();
        CloudOrigin cloudOrigin = transaction.getContext().getCloudOrigin();
        cloudOrigin.withProvider("aws");
        cloudOrigin.withServiceName(this.getAWSService());
        String region = this.getRegion(record);
        String queueArn = this.getQueueArn(record);
        if (null != queueArn) {
            String queueName = null;
            String accountId = null;
            String[] arnSegments = queueArn.split(":", -1);
            if (arnSegments.length >= 6) {
                queueName = arnSegments[5].isEmpty() ? null : arnSegments[5];
                String string = accountId = arnSegments[4].isEmpty() ? null : arnSegments[4];
                if (region == null && !arnSegments[3].isEmpty()) {
                    region = arnSegments[3];
                }
            }
            this.updateTransactionName(transaction, queueName);
            serviceOrigin.withId(queueArn);
            serviceOrigin.withName(queueName);
            String serviceOriginVersion = this.getVersion(record);
            if (null != serviceOriginVersion) {
                serviceOrigin.withVersion(serviceOriginVersion);
            }
            cloudOrigin.withAccountId(accountId);
            if (null != region) {
                cloudOrigin.withRegion(region);
            }
        }
    }

    private void updateTransactionName(Transaction transaction, @Nullable String queueName) {
        StringBuilder transactionName = transaction.getAndOverrideName(100);
        if (null != transactionName && null != queueName && !queueName.isEmpty()) {
            transactionName.append("RECEIVE ").append(queueName);
        }
    }
}

