/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda.helper;

import co.elastic.apm.agent.awslambda.helper.APIGatewayProxyV1TransactionHelper;
import co.elastic.apm.agent.awslambda.helper.APIGatewayProxyV2TransactionHelper;
import co.elastic.apm.agent.awslambda.helper.PlainTransactionHelper;
import co.elastic.apm.agent.awslambda.helper.S3TransactionHelper;
import co.elastic.apm.agent.awslambda.helper.SNSTransactionHelper;
import co.elastic.apm.agent.awslambda.helper.SQSTransactionHelper;
import co.elastic.apm.agent.impl.transaction.Transaction;
import com.amazonaws.services.lambda.runtime.Context;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyRequestEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayProxyResponseEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPEvent;
import com.amazonaws.services.lambda.runtime.events.APIGatewayV2HTTPResponse;
import com.amazonaws.services.lambda.runtime.events.S3Event;
import com.amazonaws.services.lambda.runtime.events.SNSEvent;
import com.amazonaws.services.lambda.runtime.events.SQSEvent;
import javax.annotation.Nullable;

public class AWSEventsHelper {
    @Nullable
    public static Transaction startTransaction(Object input, Context lambdaContext) {
        if (input instanceof APIGatewayV2HTTPEvent && ((APIGatewayV2HTTPEvent)input).getRequestContext() != null && ((APIGatewayV2HTTPEvent)input).getRequestContext().getHttp() != null) {
            return APIGatewayProxyV2TransactionHelper.getInstance().startTransaction((APIGatewayV2HTTPEvent)input, lambdaContext);
        }
        if (input instanceof APIGatewayProxyRequestEvent && ((APIGatewayProxyRequestEvent)input).getRequestContext() != null) {
            return APIGatewayProxyV1TransactionHelper.getInstance().startTransaction((APIGatewayProxyRequestEvent)input, lambdaContext);
        }
        if (input instanceof SQSEvent) {
            return SQSTransactionHelper.getInstance().startTransaction((SQSEvent)input, lambdaContext);
        }
        if (input instanceof SNSEvent) {
            return SNSTransactionHelper.getInstance().startTransaction((SNSEvent)input, lambdaContext);
        }
        if (input instanceof S3Event) {
            return S3TransactionHelper.getInstance().startTransaction((S3Event)input, lambdaContext);
        }
        return PlainTransactionHelper.getInstance().startTransaction(input, lambdaContext);
    }

    public static void finalizeTransaction(Transaction transaction, Object output, @Nullable Throwable thrown) {
        if (output instanceof APIGatewayV2HTTPResponse) {
            APIGatewayProxyV2TransactionHelper.getInstance().finalizeTransaction(transaction, (APIGatewayV2HTTPResponse)output, thrown);
        } else if (output instanceof APIGatewayProxyResponseEvent) {
            APIGatewayProxyV1TransactionHelper.getInstance().finalizeTransaction(transaction, (APIGatewayProxyResponseEvent)output, thrown);
        } else {
            PlainTransactionHelper.getInstance().finalizeTransaction(transaction, output, thrown);
        }
    }
}

