/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.awslambda;

import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.configuration.ServerlessConfiguration;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public abstract class AbstractAwsLambdaHandlerInstrumentation
extends TracerAwareInstrumentation {
    protected final ServerlessConfiguration serverlessConfiguration;
    @Nullable
    protected String handlerClassName;
    @Nullable
    protected String handlerMethodName;

    public AbstractAwsLambdaHandlerInstrumentation(ElasticApmTracer tracer) {
        this.serverlessConfiguration = tracer.getConfig(ServerlessConfiguration.class);
        String awsLambdaHandler = this.serverlessConfiguration.getAwsLambdaHandler();
        if (awsLambdaHandler != null && !awsLambdaHandler.isEmpty()) {
            String[] handlerConfigParts = awsLambdaHandler.split("::");
            this.handlerClassName = handlerConfigParts[0];
            if (handlerConfigParts.length > 1) {
                this.handlerMethodName = handlerConfigParts[1];
            }
        }
    }

    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Collections.singleton("aws-lambda");
    }

    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        if (this.handlerClassName == null) {
            return ElementMatchers.none();
        }
        return ElementMatchers.named(this.handlerClassName);
    }
}

