/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.asynchttpclient;

import co.elastic.apm.agent.asynchttpclient.RequestHeaderSetter;
import co.elastic.apm.agent.bci.TracerAwareInstrumentation;
import co.elastic.apm.agent.bci.bytebuddy.CustomElementMatchers;
import co.elastic.apm.agent.collections.WeakConcurrentProviderImpl;
import co.elastic.apm.agent.httpclient.HttpClientHelper;
import co.elastic.apm.agent.impl.ElasticApmTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import co.elastic.apm.agent.impl.transaction.Outcome;
import co.elastic.apm.agent.impl.transaction.Span;
import co.elastic.apm.agent.sdk.DynamicTransformer;
import co.elastic.apm.agent.sdk.ElasticApmInstrumentation;
import co.elastic.apm.agent.sdk.weakconcurrent.WeakMap;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nullable;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;
import org.asynchttpclient.AsyncHandler;
import org.asynchttpclient.HttpResponseStatus;
import org.asynchttpclient.Request;
import org.asynchttpclient.handler.MaxRedirectException;
import org.asynchttpclient.uri.Uri;

public abstract class AbstractAsyncHttpClientInstrumentation
extends TracerAwareInstrumentation {
    @Override
    public Collection<String> getInstrumentationGroupNames() {
        return Arrays.asList("http-client", "asynchttpclient");
    }

    @Override
    public ElementMatcher.Junction<ClassLoader> getClassLoaderMatcher() {
        return ElementMatchers.not(ElementMatchers.isBootstrapClassLoader()).and(CustomElementMatchers.classLoaderCanLoadClass("org.asynchttpclient.AsyncHandler"));
    }

    public static class StreamedAsyncHandlerOnStreamInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public StreamedAsyncHandlerOnStreamInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("onStream").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.reactivestreams.Publisher"))));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler) {
                return Helper.getAndActivateSpan(asyncHandler);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void onMethodExit(@Nullable @Advice.Enter Object spanObj) {
                Span span = (Span)spanObj;
                if (span != null) {
                    span.deactivate();
                }
            }
        }
    }

    public static class AsyncHandlerOnStatusReceivedInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnStatusReceivedInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("onStatusReceived").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.asynchttpclient.HttpResponseStatus"))));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler) {
                return Helper.getAndActivateSpan(asyncHandler);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void onMethodExit(@Nullable @Advice.Enter Object spanObj, @Advice.Argument(value=0) HttpResponseStatus status) {
                Span span = (Span)spanObj;
                if (span != null) {
                    span.getContext().getHttp().withStatusCode(status.getStatusCode());
                    span.deactivate();
                }
            }
        }
    }

    public static class AsyncHandlerOnThrowableInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnThrowableInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("onThrowable").and(ElementMatchers.takesArguments(Throwable.class)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler) {
                return Helper.removeAndActivateSpan(asyncHandler);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void onMethodExit(@Nullable @Advice.Enter Object spanObj, @Advice.Argument(value=0) Throwable t) {
                Span span = (Span)spanObj;
                if (span != null) {
                    if (t instanceof MaxRedirectException) {
                        span.withOutcome(Outcome.FAILURE);
                    }
                    ((Span)span.captureException(t)).end();
                    span.deactivate();
                }
            }
        }
    }

    public static class AsyncHandlerOnCompletedInstrumentation
    extends AbstractAsyncHandlerInstrumentation {
        public AsyncHandlerOnCompletedInstrumentation(ElasticApmTracer tracer) {
            super(ElementMatchers.named("onCompleted").and(ElementMatchers.takesArguments(0)));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onMethodEnter(@Advice.This AsyncHandler<?> asyncHandler) {
                return Helper.removeAndActivateSpan(asyncHandler);
            }

            @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
            public static void onMethodExit(@Nullable @Advice.Enter Object spanObj) {
                Span span = (Span)spanObj;
                if (span != null) {
                    span.end();
                    span.deactivate();
                }
            }
        }
    }

    public static abstract class AbstractAsyncHandlerInstrumentation
    extends AbstractAsyncHttpClientInstrumentation {
        private final ElementMatcher<? super MethodDescription> methodMatcher;

        protected AbstractAsyncHandlerInstrumentation(ElementMatcher<? super MethodDescription> methodMatcher) {
            this.methodMatcher = methodMatcher;
        }

        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.any();
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return this.methodMatcher;
        }
    }

    public static class AsyncHttpClientInstrumentation
    extends AbstractAsyncHttpClientInstrumentation {
        @Override
        public ElementMatcher<? super TypeDescription> getTypeMatcher() {
            return ElementMatchers.named("org.asynchttpclient.DefaultAsyncHttpClient");
        }

        @Override
        public ElementMatcher<? super MethodDescription> getMethodMatcher() {
            return ElementMatchers.named("executeRequest").and(ElementMatchers.takesArgument(0, ElementMatchers.named("org.asynchttpclient.Request"))).and(ElementMatchers.takesArgument(1, ElementMatchers.named("org.asynchttpclient.AsyncHandler")));
        }

        public static class AdviceClass {
            @Nullable
            @Advice.OnMethodEnter(suppress=Throwable.class, inline=false)
            public static Object onBeforeExecute(@Advice.Argument(value=0) Request request, @Advice.Argument(value=1) AsyncHandler<?> asyncHandler) {
                AbstractSpan<?> parent = TracerAwareInstrumentation.tracer.getActive();
                if (parent == null) {
                    return null;
                }
                DynamicTransformer.ensureInstrumented(asyncHandler.getClass(), Helper.ASYNC_HANDLER_INSTRUMENTATIONS);
                Uri uri = request.getUri();
                Span span = HttpClientHelper.startHttpClientSpan(parent, request.getMethod(), uri.toUrl(), uri.getScheme(), uri.getHost(), uri.getPort());
                if (span != null) {
                    span.activate();
                    span.propagateTraceContext(request, RequestHeaderSetter.INSTANCE);
                    Helper.handlerSpanMap.put(asyncHandler, span);
                } else {
                    parent.propagateTraceContext(request, RequestHeaderSetter.INSTANCE);
                }
                return span;
            }

            @Advice.OnMethodExit(suppress=Throwable.class, onThrowable=Throwable.class, inline=false)
            public static void onAfterExecute(@Advice.Enter @Nullable Object spanObj, @Advice.Argument(value=1) AsyncHandler<?> asyncHandler, @Advice.Thrown @Nullable Throwable t) {
                if (spanObj == null) {
                    return;
                }
                Span span = (Span)spanObj;
                span.deactivate();
                if (t != null) {
                    Helper.handlerSpanMap.remove(asyncHandler);
                    ((Span)span.captureException(t)).end();
                }
            }
        }
    }

    public static class Helper {
        static final WeakMap<AsyncHandler<?>, Span> handlerSpanMap = WeakConcurrentProviderImpl.createWeakSpanMap();
        public static final List<Class<? extends ElasticApmInstrumentation>> ASYNC_HANDLER_INSTRUMENTATIONS = Arrays.asList(AsyncHandlerOnCompletedInstrumentation.class, AsyncHandlerOnThrowableInstrumentation.class, AsyncHandlerOnStatusReceivedInstrumentation.class, StreamedAsyncHandlerOnStreamInstrumentation.class);

        @Nullable
        static Span removeAndActivateSpan(AsyncHandler<?> asyncHandler) {
            Span span = handlerSpanMap.remove(asyncHandler);
            if (span != null) {
                span.activate();
            }
            return span;
        }

        @Nullable
        static Span getAndActivateSpan(AsyncHandler<?> asyncHandler) {
            Span span = handlerSpanMap.get(asyncHandler);
            if (span != null) {
                span.activate();
            }
            return span;
        }
    }
}

