/*
 * Decompiled with CFR 0.152.
 */
package org.stagemonitor.configuration.converter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.stagemonitor.configuration.converter.AbstractCollectionValueConverter;
import org.stagemonitor.configuration.converter.IntegerValueConverter;
import org.stagemonitor.configuration.converter.StringValueConverter;
import org.stagemonitor.configuration.converter.ValueConverter;

public class ListValueConverter<T>
extends AbstractCollectionValueConverter<List<T>, T> {
    public static final ListValueConverter<String> STRINGS_VALUE_CONVERTER = new ListValueConverter<String>(StringValueConverter.INSTANCE);
    public static final ListValueConverter<String> LOWER_STRINGS_VALUE_CONVERTER = new ListValueConverter<String>(StringValueConverter.LOWER_CASE);
    public static final ValueConverter<List<Integer>> INTEGERS = new ListValueConverter<Integer>(IntegerValueConverter.INSTANCE);

    public ListValueConverter(ValueConverter<T> valueConverter) {
        super(valueConverter);
    }

    @Override
    public List<T> convert(String s) {
        if (s != null && s.length() > 0) {
            ArrayList result = new ArrayList();
            for (String split : s.split(",")) {
                result.add(this.valueConverter.convert(split.trim()));
            }
            return Collections.unmodifiableList(result);
        }
        return Collections.emptyList();
    }
}

