/*
 * Decompiled with CFR 0.152.
 */
package org.stagemonitor.configuration;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.stagemonitor.configuration.ConfigurationOption;

public abstract class ConfigurationOptionProvider {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    public List<ConfigurationOption<?>> getConfigurationOptions() {
        LinkedList configurationOptions = new LinkedList();
        for (Field field : ConfigurationOptionProvider.getAllDeclaredFields(this.getClass())) {
            if (!ConfigurationOption.class.isAssignableFrom(field.getType())) continue;
            field.setAccessible(true);
            try {
                configurationOptions.add((ConfigurationOption)field.get(this));
            }
            catch (IllegalAccessException e) {
                this.logger.warn(e.getMessage(), e);
            }
        }
        return configurationOptions;
    }

    private static List<Field> getAllDeclaredFields(Class<?> type) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> c = type; c != null; c = c.getSuperclass()) {
            fields.addAll(Arrays.asList(c.getDeclaredFields()));
        }
        return fields;
    }
}

