/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web.http2;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.vertx.v3.web.ResponseEndHandlerWrapper;
import co.elastic.apm.agent.vertx.v3.web.WebHelper;
import co.elastic.apm.agent.vertx.v3.web.WebInstrumentation;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.impl.Http2ServerRequestImpl;
import net.bytebuddy.asm.Advice;
import net.bytebuddy.description.method.MethodDescription;
import net.bytebuddy.description.type.TypeDescription;
import net.bytebuddy.matcher.ElementMatcher;
import net.bytebuddy.matcher.ElementMatchers;

public class Http2Instrumentation
extends WebInstrumentation {
    @Override
    public ElementMatcher<? super TypeDescription> getTypeMatcher() {
        return ElementMatchers.named("io.vertx.core.http.impl.Http2ServerRequestImpl");
    }

    @Override
    public ElementMatcher<? super MethodDescription> getMethodMatcher() {
        return ElementMatchers.isConstructor();
    }

    @Override
    public String getAdviceClassName() {
        return "co.elastic.apm.agent.vertx.v3.web.http2.Http2Instrumentation$Http2ServerRequestAdvice";
    }

    public static class Http2ServerRequestAdvice {
        @Advice.OnMethodExit(suppress=Throwable.class, inline=false)
        public static void enter(@Advice.This Http2ServerRequestImpl request) {
            Transaction transaction = WebHelper.getInstance().startOrGetTransaction((HttpServerRequest)request);
            if (transaction != null && request.response() != null) {
                request.response().endHandler((Handler)new ResponseEndHandlerWrapper(transaction, (HttpServerResponse)request.response(), (HttpServerRequest)request));
            }
        }
    }
}

