/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx.v3.web;

import co.elastic.apm.agent.impl.transaction.Transaction;
import co.elastic.apm.agent.vertx.v3.web.WebHelper;
import io.vertx.core.Handler;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import javax.annotation.Nullable;

public class ResponseEndHandlerWrapper
implements Handler<Void> {
    private static final WebHelper helper = WebHelper.getInstance();
    @Nullable
    private Handler<Void> actualHandler;
    private final Transaction transaction;
    private final HttpServerResponse response;
    @Nullable
    private final HttpServerRequest request;

    public ResponseEndHandlerWrapper(Transaction transaction, HttpServerResponse response, @Nullable HttpServerRequest request) {
        this.transaction = transaction;
        this.response = response;
        this.request = request;
    }

    public ResponseEndHandlerWrapper(Transaction transaction, HttpServerResponse response) {
        this(transaction, response, null);
    }

    public void setActualHandler(Handler<Void> actualHandler) {
        this.actualHandler = actualHandler;
    }

    public void handle(Void event) {
        try {
            if (this.actualHandler != null) {
                this.actualHandler.handle((Object)event);
            }
        }
        finally {
            helper.finalizeTransaction(this.response, this.transaction);
            if (this.request != null) {
                helper.removeTransactionFromContext(this.request);
            }
        }
    }
}

