/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.vertx;

import co.elastic.apm.agent.impl.GlobalTracer;
import co.elastic.apm.agent.impl.transaction.AbstractSpan;
import io.vertx.core.Handler;

public class GenericHandlerWrapper<T>
implements Handler<T> {
    protected final Handler<T> actualHandler;
    private final AbstractSpan<?> parentSpan;

    public GenericHandlerWrapper(AbstractSpan<?> parentSpan, Handler<T> actualHandler) {
        this.parentSpan = parentSpan;
        this.actualHandler = actualHandler;
        parentSpan.incrementReferences();
    }

    public void handle(T event) {
        this.parentSpan.activate();
        this.parentSpan.decrementReferences();
        try {
            this.actualHandler.handle(event);
        }
        catch (Throwable throwable) {
            this.parentSpan.captureException(throwable);
            throw throwable;
        }
        finally {
            this.parentSpan.deactivate();
        }
    }

    public static <T> Handler<T> wrapIfActiveSpan(Handler<T> handler) {
        AbstractSpan<?> currentSpan = GlobalTracer.get().getActive();
        if (currentSpan != null) {
            handler = new GenericHandlerWrapper<T>(currentSpan, handler);
        }
        return handler;
    }
}

