/*
 * Decompiled with CFR 0.152.
 */
package co.elastic.apm.agent.util;

public class Version
implements Comparable<Version> {
    public static final Version UNKNOWN_VERSION = Version.of("1.0.0");
    private final int[] numbers;

    public static Version of(String version) {
        return new Version(version);
    }

    private Version(String version) {
        int indexOfDash = version.indexOf(45);
        int indexOfFirstDot = version.indexOf(46);
        if (indexOfDash > 0 && indexOfDash < indexOfFirstDot) {
            version = version.substring(indexOfDash + 1);
        }
        indexOfDash = version.indexOf(45);
        int indexOfLastDot = version.lastIndexOf(46);
        if (indexOfDash > 0 && indexOfDash > indexOfLastDot) {
            version = version.substring(0, indexOfDash);
        }
        String[] parts = version.split("\\.");
        int[] tmp = new int[parts.length];
        int validPartsIndex = 0;
        for (String part : parts) {
            try {
                tmp[validPartsIndex] = Integer.valueOf(part);
                ++validPartsIndex;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.numbers = new int[validPartsIndex];
        if (this.numbers.length > 0) {
            System.arraycopy(tmp, 0, this.numbers, 0, this.numbers.length);
        }
    }

    @Override
    public int compareTo(Version another) {
        int maxLength = Math.max(this.numbers.length, another.numbers.length);
        for (int i = 0; i < maxLength; ++i) {
            int right;
            int left = i < this.numbers.length ? this.numbers[i] : 0;
            int n = right = i < another.numbers.length ? another.numbers[i] : 0;
            if (left == right) continue;
            return left < right ? -1 : 1;
        }
        return 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.numbers.length; ++i) {
            sb.append(this.numbers[i]);
            if (i >= this.numbers.length - 1) continue;
            sb.append('.');
        }
        return sb.toString();
    }
}

